/*
 * Decompiled with CFR 0.152.
 */
package io.eiren.util.logging;

import io.eiren.util.logging.ShortConsoleLogFormatter;
import java.text.SimpleDateFormat;
import java.util.logging.LogRecord;

public class PreciseConsoleLogFormatter
extends ShortConsoleLogFormatter {
    private final long startMills = System.currentTimeMillis();

    @Override
    protected SimpleDateFormat createDateFormat() {
        return new SimpleDateFormat("mm:ss.SSS");
    }

    @Override
    protected void buildMessage(StringBuilder builder, LogRecord record) {
        builder.append(this.date.format(record.getMillis() - this.startMills));
        builder.append(" [");
        builder.append(record.getLevel().getLocalizedName().toUpperCase());
        builder.append("] ");
        builder.append(record.getMessage());
        builder.append('\n');
    }
}

