/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0018\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/ktor/server/engine/DefaultUncaughtExceptionHandler;", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "logger", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "(Lorg/slf4j/Logger;)V", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "key", "Lkotlin/coroutines/CoroutineContext$Key;", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "handleException", "", "context", "Lkotlin/coroutines/CoroutineContext;", "exception", "", "ktor-server-host-common"})
public final class DefaultUncaughtExceptionHandler
implements CoroutineExceptionHandler {
    @NotNull
    private final Function0<Logger> logger;

    public DefaultUncaughtExceptionHandler(@NotNull Function0<? extends Logger> logger) {
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.logger = logger;
    }

    public DefaultUncaughtExceptionHandler(final @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(logger, "logger");
        this((Function0<? extends Logger>)new Function0<Logger>(){

            @Override
            @NotNull
            public final Logger invoke() {
                return logger;
            }
        });
    }

    @Override
    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return CoroutineExceptionHandler.Key;
    }

    @Override
    public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(exception, "exception");
        if (exception instanceof CancellationException) {
            return;
        }
        if (exception instanceof IOException) {
            return;
        }
        Object object = (CoroutineName)context.get(CoroutineName.Key);
        if (object == null) {
            object = context.toString();
        }
        CoroutineName coroutineName = object;
        this.logger.invoke().error("Unhandled exception caught for " + coroutineName, exception);
    }

    @Override
    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return CoroutineExceptionHandler.DefaultImpls.fold(this, initial, operation);
    }

    @Override
    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key2) {
        return CoroutineExceptionHandler.DefaultImpls.get(this, key2);
    }

    @Override
    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key2) {
        return CoroutineExceptionHandler.DefaultImpls.minusKey(this, key2);
    }

    @Override
    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        return CoroutineExceptionHandler.DefaultImpls.plus(this, context);
    }
}

