/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Parameters;
import io.ktor.http.ParametersKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B#\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u001a"}, d2={"Lio/ktor/server/routing/PathSegmentTailcardRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "name", "", "prefix", "hasTrailingSlash", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPrefix", "component1", "component2", "copy", "equals", "other", "", "evaluate", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "context", "Lio/ktor/server/routing/RoutingResolveContext;", "segmentIndex", "", "hashCode", "toString", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRouteSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/PathSegmentTailcardRouteSelector\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,700:1\n1766#2,2:701\n1#3:703\n1559#4:704\n1590#4,4:705\n*S KotlinDebug\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/PathSegmentTailcardRouteSelector\n*L\n445#1:701,2\n461#1:704\n461#1:705,4\n*E\n"})
public final class PathSegmentTailcardRouteSelector
extends RouteSelector {
    @NotNull
    private final String name;
    @NotNull
    private final String prefix;

    public PathSegmentTailcardRouteSelector(@NotNull String name, @NotNull String prefix) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            this.name = name;
            this.prefix = prefix;
            CharSequence $this$none$iv = this.prefix;
            boolean $i$f$none = false;
            for (int i = 0; i < $this$none$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$none$iv.charAt(i);
                boolean bl2 = false;
                if (!(it == '/')) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Multisegment prefix is not supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ PathSegmentTailcardRouteSelector(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @Deprecated(message="hasTrailingSlash is not used anymore. This is going to be removed", replaceWith=@ReplaceWith(expression="PathSegmentTailcardRouteSelector(name, prefix)", imports={}), level=DeprecationLevel.ERROR)
    public PathSegmentTailcardRouteSelector(@NotNull String name, @NotNull String prefix, boolean hasTrailingSlash) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        this(name, prefix);
    }

    public /* synthetic */ PathSegmentTailcardRouteSelector(String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        Parameters parameters2;
        String segmentText;
        Intrinsics.checkNotNullParameter(context, "context");
        List<String> segments2 = context.getSegments();
        if (((CharSequence)this.prefix).length() > 0 && ((segmentText = CollectionsKt.getOrNull(segments2, segmentIndex)) == null || !StringsKt.startsWith$default(segmentText, this.prefix, false, 2, null))) {
            return RouteSelectorEvaluation.Companion.getFailedPath();
        }
        if (((CharSequence)this.name).length() == 0) {
            parameters2 = ParametersKt.parametersOf();
        } else {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable iterable = CollectionsKt.drop((Iterable)segments2, segmentIndex);
            String string = this.name;
            boolean $i$f$mapIndexed = false;
            void var7_9 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void segment;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(index == false ? StringsKt.drop((String)segment, this.prefix.length()) : segment);
            }
            parameters2 = ParametersKt.parametersOf(string, (List)destination$iv$iv);
        }
        Parameters values2 = parameters2;
        double quality = segmentIndex < segments2.size() ? 0.1 : 0.2;
        return new RouteSelectorEvaluation.Success(quality, values2, segments2.size() - segmentIndex);
    }

    @NotNull
    public String toString() {
        return "{...}";
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.prefix;
    }

    @NotNull
    public final PathSegmentTailcardRouteSelector copy(@NotNull String name, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        return new PathSegmentTailcardRouteSelector(name, prefix);
    }

    public static /* synthetic */ PathSegmentTailcardRouteSelector copy$default(PathSegmentTailcardRouteSelector pathSegmentTailcardRouteSelector, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = pathSegmentTailcardRouteSelector.name;
        }
        if ((n & 2) != 0) {
            string2 = pathSegmentTailcardRouteSelector.prefix;
        }
        return pathSegmentTailcardRouteSelector.copy(string, string2);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.prefix.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathSegmentTailcardRouteSelector)) {
            return false;
        }
        PathSegmentTailcardRouteSelector pathSegmentTailcardRouteSelector = (PathSegmentTailcardRouteSelector)other;
        if (!Intrinsics.areEqual(this.name, pathSegmentTailcardRouteSelector.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.prefix, pathSegmentTailcardRouteSelector.prefix);
    }

    public PathSegmentTailcardRouteSelector() {
        this(null, null, 3, null);
    }
}

