/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GenericProgressiveFutureListener;
import java.util.Arrays;

final class DefaultFutureListeners {
    private GenericFutureListener<? extends Future<?>>[] listeners = new GenericFutureListener[2];
    private int size;
    private int progressiveSize;

    DefaultFutureListeners(GenericFutureListener<? extends Future<?>> first, GenericFutureListener<? extends Future<?>> second2) {
        this.listeners[0] = first;
        this.listeners[1] = second2;
        this.size = 2;
        if (first instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
        if (second2 instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
    }

    public void add(GenericFutureListener<? extends Future<?>> l) {
        int size2 = this.size;
        GenericFutureListener<? extends Future<?>>[] listeners = this.listeners;
        if (size2 == listeners.length) {
            this.listeners = listeners = Arrays.copyOf(listeners, size2 << 1);
        }
        listeners[size2] = l;
        this.size = size2 + 1;
        if (l instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
    }

    public void remove(GenericFutureListener<? extends Future<?>> l) {
        GenericFutureListener<? extends Future<?>>[] listeners = this.listeners;
        int size2 = this.size;
        for (int i = 0; i < size2; ++i) {
            if (listeners[i] != l) continue;
            int listenersToMove = size2 - i - 1;
            if (listenersToMove > 0) {
                System.arraycopy(listeners, i + 1, listeners, i, listenersToMove);
            }
            listeners[--size2] = null;
            this.size = size2;
            if (l instanceof GenericProgressiveFutureListener) {
                --this.progressiveSize;
            }
            return;
        }
    }

    public GenericFutureListener<? extends Future<?>>[] listeners() {
        return this.listeners;
    }

    public int size() {
        return this.size;
    }

    public int progressiveSize() {
        return this.progressiveSize;
    }
}

