/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.jmdns.impl.JmDNSImpl;

public abstract class JmDNS
implements Closeable {
    public static String VERSION;

    public static JmDNS create() throws IOException {
        return new JmDNSImpl(null, null);
    }

    public static JmDNS create(InetAddress addr) throws IOException {
        return new JmDNSImpl(addr, null);
    }

    public static JmDNS create(String name) throws IOException {
        return new JmDNSImpl(null, name);
    }

    public static JmDNS create(InetAddress addr, String name, long threadSleepDurationMs) throws IOException {
        return new JmDNSImpl(addr, name, threadSleepDurationMs);
    }

    public static JmDNS create(InetAddress addr, String name) throws IOException {
        return new JmDNSImpl(addr, name, 0L);
    }

    public abstract String getName();

    public abstract String getHostName();

    public abstract InetAddress getInetAddress() throws IOException;

    @Deprecated
    public abstract InetAddress getInterface() throws IOException;

    public abstract ServiceInfo getServiceInfo(String var1, String var2);

    public abstract ServiceInfo getServiceInfo(String var1, String var2, long var3);

    public abstract ServiceInfo getServiceInfo(String var1, String var2, boolean var3);

    public abstract ServiceInfo getServiceInfo(String var1, String var2, boolean var3, long var4);

    public abstract void requestServiceInfo(String var1, String var2);

    public abstract void requestServiceInfo(String var1, String var2, boolean var3);

    public abstract void requestServiceInfo(String var1, String var2, long var3);

    public abstract void requestServiceInfo(String var1, String var2, boolean var3, long var4);

    public abstract void addServiceTypeListener(ServiceTypeListener var1) throws IOException;

    public abstract void removeServiceTypeListener(ServiceTypeListener var1);

    public abstract void addServiceListener(String var1, ServiceListener var2);

    public abstract void removeServiceListener(String var1, ServiceListener var2);

    public abstract void registerService(ServiceInfo var1) throws IOException;

    public abstract void unregisterService(ServiceInfo var1);

    public abstract void unregisterAllServices();

    public abstract boolean registerServiceType(String var1);

    @Deprecated
    public abstract void printServices();

    public abstract ServiceInfo[] list(String var1);

    public abstract ServiceInfo[] list(String var1, long var2);

    public abstract Map<String, ServiceInfo[]> listBySubtype(String var1);

    public abstract Map<String, ServiceInfo[]> listBySubtype(String var1, long var2);

    public abstract Delegate getDelegate();

    public abstract Delegate setDelegate(Delegate var1);

    static {
        try (InputStream inputStream2 = JmDNS.class.getClassLoader().getResourceAsStream("version.properties");){
            Properties properties = new Properties();
            properties.load(inputStream2);
            VERSION = properties.getProperty("jmdns.version");
        }
        catch (Exception ignored) {
            VERSION = "VERSION MISSING";
        }
    }

    public static interface Delegate {
        public void cannotRecoverFromIOError(JmDNS var1, Collection<ServiceInfo> var2);
    }
}

