/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DNSStatefulObject {
    public JmDNSImpl getDns();

    public void associateWithTask(DNSTask var1, DNSState var2);

    public void removeAssociationWithTask(DNSTask var1);

    public boolean isAssociatedWithTask(DNSTask var1, DNSState var2);

    public boolean advanceState(DNSTask var1);

    public boolean revertState();

    public boolean cancelState();

    public boolean closeState();

    public boolean recoverState();

    public boolean isProbing();

    public boolean isAnnouncing();

    public boolean isAnnounced();

    public boolean isCanceling();

    public boolean isCanceled();

    public boolean isClosing();

    public boolean isClosed();

    public boolean waitForAnnounced(long var1);

    public boolean waitForCanceled(long var1);

    public static class DefaultImplementation
    extends ReentrantLock
    implements DNSStatefulObject {
        private static Logger logger = LoggerFactory.getLogger(DefaultImplementation.class);
        private static final long serialVersionUID = -3264781576883412227L;
        private volatile JmDNSImpl _dns = null;
        protected volatile DNSTask _task = null;
        protected volatile DNSState _state = DNSState.PROBING_1;
        private final DNSStatefulObjectSemaphore _announcing = new DNSStatefulObjectSemaphore("Announce");
        private final DNSStatefulObjectSemaphore _canceling = new DNSStatefulObjectSemaphore("Cancel");

        @Override
        public JmDNSImpl getDns() {
            return this._dns;
        }

        protected void setDns(JmDNSImpl dns) {
            this._dns = dns;
        }

        @Override
        public void associateWithTask(DNSTask task, DNSState state) {
            if (this._task == null && this._state == state) {
                this.lock();
                try {
                    if (this._task == null && this._state == state) {
                        this.setTask(task);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        @Override
        public void removeAssociationWithTask(DNSTask task) {
            if (this._task == task) {
                this.lock();
                try {
                    if (this._task == task) {
                        this.setTask(null);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAssociatedWithTask(DNSTask task, DNSState state) {
            this.lock();
            try {
                boolean bl = this._task == task && this._state == state;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        protected void setTask(DNSTask task) {
            this._task = task;
        }

        protected void setState(DNSState state) {
            this.lock();
            try {
                this._state = state;
                if (this.isAnnounced()) {
                    this._announcing.signalEvent();
                }
                if (this.isCanceled()) {
                    this._canceling.signalEvent();
                    this._announcing.signalEvent();
                }
            }
            finally {
                this.unlock();
            }
        }

        @Override
        public boolean advanceState(DNSTask task) {
            boolean result = true;
            if (this._task == task) {
                this.lock();
                try {
                    if (this._task == task) {
                        this.setState(this._state.advance());
                    } else {
                        logger.warn("Trying to advance state whhen not the owner. owner: {} perpetrator: {}", (Object)this._task, (Object)task);
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        @Override
        public boolean revertState() {
            boolean result = true;
            if (!this.willCancel()) {
                this.lock();
                try {
                    if (!this.willCancel()) {
                        this.setState(this._state.revert());
                        this.setTask(null);
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        @Override
        public boolean cancelState() {
            boolean result = false;
            if (!this.willCancel()) {
                this.lock();
                try {
                    if (!this.willCancel()) {
                        this.setState(DNSState.CANCELING_1);
                        this.setTask(null);
                        result = true;
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        @Override
        public boolean closeState() {
            boolean result = false;
            if (!this.willClose()) {
                this.lock();
                try {
                    if (!this.willClose()) {
                        this.setState(DNSState.CLOSING);
                        this.setTask(null);
                        result = true;
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        @Override
        public boolean recoverState() {
            boolean result = false;
            this.lock();
            try {
                this.setState(DNSState.PROBING_1);
                this.setTask(null);
            }
            finally {
                this.unlock();
            }
            return result;
        }

        @Override
        public boolean isProbing() {
            return this._state.isProbing();
        }

        @Override
        public boolean isAnnouncing() {
            return this._state.isAnnouncing();
        }

        @Override
        public boolean isAnnounced() {
            return this._state.isAnnounced();
        }

        @Override
        public boolean isCanceling() {
            return this._state.isCanceling();
        }

        @Override
        public boolean isCanceled() {
            return this._state.isCanceled();
        }

        @Override
        public boolean isClosing() {
            return this._state.isClosing();
        }

        @Override
        public boolean isClosed() {
            return this._state.isClosed();
        }

        private boolean willCancel() {
            return this._state.isCanceled() || this._state.isCanceling();
        }

        private boolean willClose() {
            return this._state.isClosed() || this._state.isClosing();
        }

        @Override
        public boolean waitForAnnounced(long timeout) {
            if (!this.isAnnounced() && !this.willCancel()) {
                this._announcing.waitForEvent(timeout + 10L);
            }
            if (!this.isAnnounced()) {
                this._announcing.waitForEvent(10L);
                if (!this.isAnnounced()) {
                    if (this.willCancel() || this.willClose()) {
                        logger.debug("Wait for announced cancelled: {}", (Object)this);
                    } else {
                        logger.warn("Wait for announced timed out: {}", (Object)this);
                    }
                }
            }
            return this.isAnnounced();
        }

        @Override
        public boolean waitForCanceled(long timeout) {
            if (!this.isCanceled()) {
                this._canceling.waitForEvent(timeout);
            }
            if (!this.isCanceled()) {
                this._canceling.waitForEvent(10L);
                if (!this.isCanceled() && !this.willClose()) {
                    logger.warn("Wait for canceled timed out: {}", (Object)this);
                }
            }
            return this.isCanceled();
        }

        @Override
        public String toString() {
            try {
                return (this._dns != null ? "DNS: " + this._dns.getName() + " [" + this._dns.getInetAddress() + "]" : "NO DNS") + " state: " + (Object)((Object)this._state) + " task: " + this._task;
            }
            catch (IOException exception) {
                return (this._dns != null ? "DNS: " + this._dns.getName() : "NO DNS") + " state: " + (Object)((Object)this._state) + " task: " + this._task;
            }
        }
    }

    public static final class DNSStatefulObjectSemaphore {
        private static Logger logger = LoggerFactory.getLogger(DNSStatefulObjectSemaphore.class);
        private final String _name;
        private final ConcurrentMap<Thread, Semaphore> _semaphores;

        public DNSStatefulObjectSemaphore(String name) {
            this._name = name;
            this._semaphores = new ConcurrentHashMap<Thread, Semaphore>(50);
        }

        public void waitForEvent(long timeout) {
            Thread thread2 = Thread.currentThread();
            Semaphore semaphore = (Semaphore)this._semaphores.get(thread2);
            if (semaphore == null) {
                semaphore = new Semaphore(1, true);
                semaphore.drainPermits();
                this._semaphores.putIfAbsent(thread2, semaphore);
            }
            semaphore = (Semaphore)this._semaphores.get(thread2);
            try {
                semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException exception) {
                logger.debug("Exception ", exception);
            }
        }

        public void signalEvent() {
            Collection semaphores = this._semaphores.values();
            for (Semaphore semaphore : semaphores) {
                semaphore.release();
                semaphores.remove(semaphore);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(1000);
            sb.append("Semaphore: ");
            sb.append(this._name);
            if (this._semaphores.size() == 0) {
                sb.append(" no semaphores.");
            } else {
                sb.append(" semaphores:\n");
                for (Map.Entry entry : this._semaphores.entrySet()) {
                    sb.append("\tThread: ");
                    sb.append(((Thread)entry.getKey()).getName());
                    sb.append(' ');
                    sb.append(entry.getValue());
                    sb.append('\n');
                }
            }
            return sb.toString();
        }
    }
}

