/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.resolver;

import java.io.IOException;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.tasks.resolver.DNSResolverTask;

public class ServiceInfoResolver
extends DNSResolverTask {
    private final ServiceInfoImpl _info;

    public ServiceInfoResolver(JmDNSImpl jmDNSImpl, ServiceInfoImpl info) {
        super(jmDNSImpl);
        this._info = info;
        info.setDns(this.getDns());
        this.getDns().addListener(info, DNSQuestion.newQuestion(info.getQualifiedName(), DNSRecordType.TYPE_ANY, DNSRecordClass.CLASS_IN, false));
    }

    @Override
    public String getName() {
        return "ServiceInfoResolver(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public boolean cancel() {
        boolean result = super.cancel();
        if (!this._info.isPersistent()) {
            this.getDns().removeListener(this._info);
        }
        return result;
    }

    @Override
    protected DNSOutgoing addAnswers(DNSOutgoing out2) throws IOException {
        DNSOutgoing newOut = out2;
        if (!this._info.hasData()) {
            long now = System.currentTimeMillis();
            newOut = this.addAnswer(newOut, (DNSRecord)this.getDns().getCache().getDNSEntry(this._info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN), now);
            newOut = this.addAnswer(newOut, (DNSRecord)this.getDns().getCache().getDNSEntry(this._info.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN), now);
            if (this._info.getServer().length() > 0) {
                for (DNSEntry dNSEntry : this.getDns().getCache().getDNSEntryList(this._info.getServer(), DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN)) {
                    newOut = this.addAnswer(newOut, (DNSRecord)dNSEntry, now);
                }
                for (DNSEntry dNSEntry : this.getDns().getCache().getDNSEntryList(this._info.getServer(), DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN)) {
                    newOut = this.addAnswer(newOut, (DNSRecord)dNSEntry, now);
                }
            }
        }
        return newOut;
    }

    @Override
    protected DNSOutgoing addQuestions(DNSOutgoing out2) throws IOException {
        DNSOutgoing newOut = out2;
        if (!this._info.hasData()) {
            newOut = this.addQuestion(newOut, DNSQuestion.newQuestion(this._info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN, false));
            newOut = this.addQuestion(newOut, DNSQuestion.newQuestion(this._info.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN, false));
            if (this._info.getServer().length() > 0) {
                newOut = this.addQuestion(newOut, DNSQuestion.newQuestion(this._info.getServer(), DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN, false));
                newOut = this.addQuestion(newOut, DNSQuestion.newQuestion(this._info.getServer(), DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN, false));
            }
        }
        return newOut;
    }

    @Override
    protected String description() {
        return "querying service info: " + (this._info != null ? this._info.getQualifiedName() : "null");
    }
}

