/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.resolver;

import java.io.IOException;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.tasks.resolver.DNSResolverTask;

public class TypeResolver
extends DNSResolverTask {
    public TypeResolver(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl);
    }

    @Override
    public String getName() {
        return "TypeResolver(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    protected DNSOutgoing addAnswers(DNSOutgoing out2) throws IOException {
        DNSOutgoing newOut = out2;
        long now = System.currentTimeMillis();
        for (JmDNSImpl.ServiceTypeEntry typeEntry : this.getDns().getServiceTypes().values()) {
            newOut = this.addAnswer(newOut, new DNSRecord.Pointer("_services._dns-sd._udp.local.", DNSRecordClass.CLASS_IN, false, DNSConstants.DNS_TTL, typeEntry.getType()), now);
        }
        return newOut;
    }

    @Override
    protected DNSOutgoing addQuestions(DNSOutgoing out2) throws IOException {
        return this.addQuestion(out2, DNSQuestion.newQuestion("_services._dns-sd._udp.local.", DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false));
    }

    @Override
    protected String description() {
        return "querying type";
    }
}

