/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import org.jetbrains.annotations.NotNull;

public final class VisibilityUtilKt {
    @NotNull
    public static final CallableMemberDescriptor findMemberWithMaxVisibility(@NotNull Collection<? extends CallableMemberDescriptor> descriptors) {
        boolean bl;
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        boolean bl2 = bl = !descriptors.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        CallableMemberDescriptor descriptor = null;
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            if (descriptor == null) {
                descriptor = callableMemberDescriptor;
                continue;
            }
            Integer result = DescriptorVisibilities.compare(descriptor.getVisibility(), callableMemberDescriptor.getVisibility());
            if (result == null || result >= 0) continue;
            descriptor = callableMemberDescriptor;
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor;
        Intrinsics.checkNotNull(callableMemberDescriptor);
        return callableMemberDescriptor;
    }
}

