/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.hid4java.HidDevice;
import org.hid4java.HidServicesListener;
import org.hid4java.event.HidServicesEvent;

public class HidServicesListenerList {
    private final List<HidServicesListener> listeners = Collections.synchronizedList(new ArrayList());
    private final ExecutorService executorService = Executors.newFixedThreadPool(3, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread2 = Executors.defaultThreadFactory().newThread(runnable);
            thread2.setName("hid4java event worker");
            thread2.setDaemon(true);
            return thread2;
        }
    });

    public final void add(HidServicesListener listener2) {
        if (this.listeners.contains(listener2)) {
            return;
        }
        this.listeners.add(listener2);
    }

    public final void remove(HidServicesListener listener2) {
        this.listeners.remove(listener2);
    }

    public final void clear() {
        this.listeners.clear();
    }

    protected final List<HidServicesListener> getListeners() {
        return this.listeners;
    }

    public HidServicesListener[] toArray() {
        return this.getListeners().toArray(new HidServicesListener[0]);
    }

    public void fireHidDeviceAttached(final HidDevice hidDevice) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                HidServicesEvent event = new HidServicesEvent(hidDevice);
                for (HidServicesListener listener2 : HidServicesListenerList.this.toArray()) {
                    listener2.hidDeviceAttached(event);
                }
            }
        });
    }

    public void fireHidDeviceDetached(final HidDevice hidDevice) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                HidServicesEvent event = new HidServicesEvent(hidDevice);
                for (HidServicesListener listener2 : HidServicesListenerList.this.toArray()) {
                    listener2.hidDeviceDetached(event);
                }
            }
        });
    }

    public void fireHidFailure(final HidDevice hidDevice) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                HidServicesEvent event = new HidServicesEvent(hidDevice);
                for (HidServicesListener listener2 : HidServicesListenerList.this.toArray()) {
                    listener2.hidFailure(event);
                }
            }
        });
    }

    public void fireHidDataReceived(final HidDevice hidDevice, final byte[] dataReceived) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                HidServicesEvent event = new HidServicesEvent(hidDevice, dataReceived);
                for (HidServicesListener listener2 : HidServicesListenerList.this.toArray()) {
                    listener2.hidDataReceived(event);
                }
            }
        });
    }
}

