/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.data_feed;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.data_feed.DataFeedConfigT;
import solarxr_protocol.data_feed.device_data.DeviceDataMask;
import solarxr_protocol.data_feed.tracker.TrackerDataMask;

public final class DataFeedConfig
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static DataFeedConfig getRootAsDataFeedConfig(ByteBuffer _bb) {
        return DataFeedConfig.getRootAsDataFeedConfig(_bb, new DataFeedConfig());
    }

    public static DataFeedConfig getRootAsDataFeedConfig(ByteBuffer _bb, DataFeedConfig obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public DataFeedConfig __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int minimumTimeSinceLast() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public DeviceDataMask dataMask() {
        return this.dataMask(new DeviceDataMask());
    }

    public DeviceDataMask dataMask(DeviceDataMask obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public TrackerDataMask syntheticTrackersMask() {
        return this.syntheticTrackersMask(new TrackerDataMask());
    }

    public TrackerDataMask syntheticTrackersMask(TrackerDataMask obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public boolean boneMask() {
        int o = this.__offset(10);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean stayAlignedPoseMask() {
        int o = this.__offset(12);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public static int createDataFeedConfig(FlatBufferBuilder builder, int minimumTimeSinceLast, int dataMaskOffset, int syntheticTrackersMaskOffset, boolean boneMask, boolean stayAlignedPoseMask) {
        builder.startTable(5);
        DataFeedConfig.addSyntheticTrackersMask(builder, syntheticTrackersMaskOffset);
        DataFeedConfig.addDataMask(builder, dataMaskOffset);
        DataFeedConfig.addMinimumTimeSinceLast(builder, minimumTimeSinceLast);
        DataFeedConfig.addStayAlignedPoseMask(builder, stayAlignedPoseMask);
        DataFeedConfig.addBoneMask(builder, boneMask);
        return DataFeedConfig.endDataFeedConfig(builder);
    }

    public static void startDataFeedConfig(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addMinimumTimeSinceLast(FlatBufferBuilder builder, int minimumTimeSinceLast) {
        builder.addShort(0, (short)minimumTimeSinceLast, 0);
    }

    public static void addDataMask(FlatBufferBuilder builder, int dataMaskOffset) {
        builder.addOffset(1, dataMaskOffset, 0);
    }

    public static void addSyntheticTrackersMask(FlatBufferBuilder builder, int syntheticTrackersMaskOffset) {
        builder.addOffset(2, syntheticTrackersMaskOffset, 0);
    }

    public static void addBoneMask(FlatBufferBuilder builder, boolean boneMask) {
        builder.addBoolean(3, boneMask, false);
    }

    public static void addStayAlignedPoseMask(FlatBufferBuilder builder, boolean stayAlignedPoseMask) {
        builder.addBoolean(4, stayAlignedPoseMask, false);
    }

    public static int endDataFeedConfig(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public DataFeedConfigT unpack() {
        DataFeedConfigT _o = new DataFeedConfigT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(DataFeedConfigT _o) {
        int _oMinimumTimeSinceLast = this.minimumTimeSinceLast();
        _o.setMinimumTimeSinceLast(_oMinimumTimeSinceLast);
        if (this.dataMask() != null) {
            _o.setDataMask(this.dataMask().unpack());
        } else {
            _o.setDataMask(null);
        }
        if (this.syntheticTrackersMask() != null) {
            _o.setSyntheticTrackersMask(this.syntheticTrackersMask().unpack());
        } else {
            _o.setSyntheticTrackersMask(null);
        }
        boolean _oBoneMask = this.boneMask();
        _o.setBoneMask(_oBoneMask);
        boolean _oStayAlignedPoseMask = this.stayAlignedPoseMask();
        _o.setStayAlignedPoseMask(_oStayAlignedPoseMask);
    }

    public static int pack(FlatBufferBuilder builder, DataFeedConfigT _o) {
        if (_o == null) {
            return 0;
        }
        int _dataMask = _o.getDataMask() == null ? 0 : DeviceDataMask.pack(builder, _o.getDataMask());
        int _syntheticTrackersMask = _o.getSyntheticTrackersMask() == null ? 0 : TrackerDataMask.pack(builder, _o.getSyntheticTrackersMask());
        return DataFeedConfig.createDataFeedConfig(builder, _o.getMinimumTimeSinceLast(), _dataMask, _syntheticTrackersMask, _o.getBoneMask(), _o.getStayAlignedPoseMask());
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public DataFeedConfig get(int j) {
            return this.get(new DataFeedConfig(), j);
        }

        public DataFeedConfig get(DataFeedConfig obj, int j) {
            return obj.__assign(DataFeedConfig.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

