/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.data_feed;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.data_feed.Bone;
import solarxr_protocol.data_feed.BoneT;
import solarxr_protocol.data_feed.DataFeedUpdateT;
import solarxr_protocol.data_feed.device_data.DeviceData;
import solarxr_protocol.data_feed.device_data.DeviceDataT;
import solarxr_protocol.data_feed.stay_aligned.StayAlignedPose;
import solarxr_protocol.data_feed.tracker.TrackerData;
import solarxr_protocol.data_feed.tracker.TrackerDataT;

public final class DataFeedUpdate
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static DataFeedUpdate getRootAsDataFeedUpdate(ByteBuffer _bb) {
        return DataFeedUpdate.getRootAsDataFeedUpdate(_bb, new DataFeedUpdate());
    }

    public static DataFeedUpdate getRootAsDataFeedUpdate(ByteBuffer _bb, DataFeedUpdate obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public DataFeedUpdate __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public DeviceData devices(int j) {
        return this.devices(new DeviceData(), j);
    }

    public DeviceData devices(DeviceData obj, int j) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int devicesLength() {
        int o = this.__offset(4);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public DeviceData.Vector devicesVector() {
        return this.devicesVector(new DeviceData.Vector());
    }

    public DeviceData.Vector devicesVector(DeviceData.Vector obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public TrackerData syntheticTrackers(int j) {
        return this.syntheticTrackers(new TrackerData(), j);
    }

    public TrackerData syntheticTrackers(TrackerData obj, int j) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int syntheticTrackersLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public TrackerData.Vector syntheticTrackersVector() {
        return this.syntheticTrackersVector(new TrackerData.Vector());
    }

    public TrackerData.Vector syntheticTrackersVector(TrackerData.Vector obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public Bone bones(int j) {
        return this.bones(new Bone(), j);
    }

    public Bone bones(Bone obj, int j) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int bonesLength() {
        int o = this.__offset(8);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public Bone.Vector bonesVector() {
        return this.bonesVector(new Bone.Vector());
    }

    public Bone.Vector bonesVector(Bone.Vector obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public StayAlignedPose stayAlignedPose() {
        return this.stayAlignedPose(new StayAlignedPose());
    }

    public StayAlignedPose stayAlignedPose(StayAlignedPose obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public int index() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public static int createDataFeedUpdate(FlatBufferBuilder builder, int devicesOffset, int syntheticTrackersOffset, int bonesOffset, int stayAlignedPoseOffset, int index) {
        builder.startTable(5);
        DataFeedUpdate.addStayAlignedPose(builder, stayAlignedPoseOffset);
        DataFeedUpdate.addBones(builder, bonesOffset);
        DataFeedUpdate.addSyntheticTrackers(builder, syntheticTrackersOffset);
        DataFeedUpdate.addDevices(builder, devicesOffset);
        DataFeedUpdate.addIndex(builder, index);
        return DataFeedUpdate.endDataFeedUpdate(builder);
    }

    public static void startDataFeedUpdate(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addDevices(FlatBufferBuilder builder, int devicesOffset) {
        builder.addOffset(0, devicesOffset, 0);
    }

    public static int createDevicesVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startDevicesVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addSyntheticTrackers(FlatBufferBuilder builder, int syntheticTrackersOffset) {
        builder.addOffset(1, syntheticTrackersOffset, 0);
    }

    public static int createSyntheticTrackersVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startSyntheticTrackersVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addBones(FlatBufferBuilder builder, int bonesOffset) {
        builder.addOffset(2, bonesOffset, 0);
    }

    public static int createBonesVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startBonesVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addStayAlignedPose(FlatBufferBuilder builder, int stayAlignedPoseOffset) {
        builder.addOffset(3, stayAlignedPoseOffset, 0);
    }

    public static void addIndex(FlatBufferBuilder builder, int index) {
        builder.addByte(4, (byte)index, 0);
    }

    public static int endDataFeedUpdate(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public DataFeedUpdateT unpack() {
        DataFeedUpdateT _o = new DataFeedUpdateT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(DataFeedUpdateT _o) {
        DeviceDataT[] _oDevices = new DeviceDataT[this.devicesLength()];
        for (int _j = 0; _j < this.devicesLength(); ++_j) {
            _oDevices[_j] = this.devices(_j) != null ? this.devices(_j).unpack() : null;
        }
        _o.setDevices(_oDevices);
        TrackerDataT[] _oSyntheticTrackers = new TrackerDataT[this.syntheticTrackersLength()];
        for (int _j = 0; _j < this.syntheticTrackersLength(); ++_j) {
            _oSyntheticTrackers[_j] = this.syntheticTrackers(_j) != null ? this.syntheticTrackers(_j).unpack() : null;
        }
        _o.setSyntheticTrackers(_oSyntheticTrackers);
        BoneT[] _oBones = new BoneT[this.bonesLength()];
        for (int _j = 0; _j < this.bonesLength(); ++_j) {
            _oBones[_j] = this.bones(_j) != null ? this.bones(_j).unpack() : null;
        }
        _o.setBones(_oBones);
        if (this.stayAlignedPose() != null) {
            _o.setStayAlignedPose(this.stayAlignedPose().unpack());
        } else {
            _o.setStayAlignedPose(null);
        }
        int _oIndex = this.index();
        _o.setIndex(_oIndex);
    }

    public static int pack(FlatBufferBuilder builder, DataFeedUpdateT _o) {
        if (_o == null) {
            return 0;
        }
        int _devices = 0;
        if (_o.getDevices() != null) {
            int[] __devices = new int[_o.getDevices().length];
            int _j = 0;
            for (DeviceDataT _e : _o.getDevices()) {
                __devices[_j] = DeviceData.pack(builder, _e);
                ++_j;
            }
            _devices = DataFeedUpdate.createDevicesVector(builder, __devices);
        }
        int _syntheticTrackers = 0;
        if (_o.getSyntheticTrackers() != null) {
            int[] __syntheticTrackers = new int[_o.getSyntheticTrackers().length];
            int _j = 0;
            for (TrackerDataT _e : _o.getSyntheticTrackers()) {
                __syntheticTrackers[_j] = TrackerData.pack(builder, _e);
                ++_j;
            }
            _syntheticTrackers = DataFeedUpdate.createSyntheticTrackersVector(builder, __syntheticTrackers);
        }
        int _bones = 0;
        if (_o.getBones() != null) {
            int[] __bones = new int[_o.getBones().length];
            int _j = 0;
            for (BoneT _e : _o.getBones()) {
                __bones[_j] = Bone.pack(builder, _e);
                ++_j;
            }
            _bones = DataFeedUpdate.createBonesVector(builder, __bones);
        }
        int _stayAlignedPose = _o.getStayAlignedPose() == null ? 0 : StayAlignedPose.pack(builder, _o.getStayAlignedPose());
        return DataFeedUpdate.createDataFeedUpdate(builder, _devices, _syntheticTrackers, _bones, _stayAlignedPose, _o.getIndex());
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public DataFeedUpdate get(int j) {
            return this.get(new DataFeedUpdate(), j);
        }

        public DataFeedUpdate get(DataFeedUpdate obj, int j) {
            return obj.__assign(DataFeedUpdate.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

