/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.data_feed.device_data;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.data_feed.device_data.DeviceDataT;
import solarxr_protocol.data_feed.tracker.TrackerData;
import solarxr_protocol.data_feed.tracker.TrackerDataT;
import solarxr_protocol.datatypes.DeviceId;
import solarxr_protocol.datatypes.hardware_info.HardwareInfo;
import solarxr_protocol.datatypes.hardware_info.HardwareStatus;

public final class DeviceData
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static DeviceData getRootAsDeviceData(ByteBuffer _bb) {
        return DeviceData.getRootAsDeviceData(_bb, new DeviceData());
    }

    public static DeviceData getRootAsDeviceData(ByteBuffer _bb, DeviceData obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public DeviceData __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public DeviceId id() {
        return this.id(new DeviceId());
    }

    public DeviceId id(DeviceId obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public String customName() {
        int o = this.__offset(6);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer customNameAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public ByteBuffer customNameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 1);
    }

    public HardwareInfo hardwareInfo() {
        return this.hardwareInfo(new HardwareInfo());
    }

    public HardwareInfo hardwareInfo(HardwareInfo obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public HardwareStatus hardwareStatus() {
        return this.hardwareStatus(new HardwareStatus());
    }

    public HardwareStatus hardwareStatus(HardwareStatus obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public TrackerData trackers(int j) {
        return this.trackers(new TrackerData(), j);
    }

    public TrackerData trackers(TrackerData obj, int j) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int trackersLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public TrackerData.Vector trackersVector() {
        return this.trackersVector(new TrackerData.Vector());
    }

    public TrackerData.Vector trackersVector(TrackerData.Vector obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public static void startDeviceData(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addId(FlatBufferBuilder builder, int idOffset) {
        builder.addStruct(0, idOffset, 0);
    }

    public static void addCustomName(FlatBufferBuilder builder, int customNameOffset) {
        builder.addOffset(1, customNameOffset, 0);
    }

    public static void addHardwareInfo(FlatBufferBuilder builder, int hardwareInfoOffset) {
        builder.addOffset(2, hardwareInfoOffset, 0);
    }

    public static void addHardwareStatus(FlatBufferBuilder builder, int hardwareStatusOffset) {
        builder.addOffset(3, hardwareStatusOffset, 0);
    }

    public static void addTrackers(FlatBufferBuilder builder, int trackersOffset) {
        builder.addOffset(4, trackersOffset, 0);
    }

    public static int createTrackersVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startTrackersVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endDeviceData(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public DeviceDataT unpack() {
        DeviceDataT _o = new DeviceDataT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(DeviceDataT _o) {
        if (this.id() != null) {
            this.id().unpackTo(_o.getId());
        } else {
            _o.setId(null);
        }
        String _oCustomName = this.customName();
        _o.setCustomName(_oCustomName);
        if (this.hardwareInfo() != null) {
            _o.setHardwareInfo(this.hardwareInfo().unpack());
        } else {
            _o.setHardwareInfo(null);
        }
        if (this.hardwareStatus() != null) {
            _o.setHardwareStatus(this.hardwareStatus().unpack());
        } else {
            _o.setHardwareStatus(null);
        }
        TrackerDataT[] _oTrackers = new TrackerDataT[this.trackersLength()];
        for (int _j = 0; _j < this.trackersLength(); ++_j) {
            _oTrackers[_j] = this.trackers(_j) != null ? this.trackers(_j).unpack() : null;
        }
        _o.setTrackers(_oTrackers);
    }

    public static int pack(FlatBufferBuilder builder, DeviceDataT _o) {
        if (_o == null) {
            return 0;
        }
        int _customName = _o.getCustomName() == null ? 0 : builder.createString(_o.getCustomName());
        int _hardwareInfo = _o.getHardwareInfo() == null ? 0 : HardwareInfo.pack(builder, _o.getHardwareInfo());
        int _hardwareStatus = _o.getHardwareStatus() == null ? 0 : HardwareStatus.pack(builder, _o.getHardwareStatus());
        int _trackers = 0;
        if (_o.getTrackers() != null) {
            int[] __trackers = new int[_o.getTrackers().length];
            int _j = 0;
            for (TrackerDataT _e : _o.getTrackers()) {
                __trackers[_j] = TrackerData.pack(builder, _e);
                ++_j;
            }
            _trackers = DeviceData.createTrackersVector(builder, __trackers);
        }
        DeviceData.startDeviceData(builder);
        DeviceData.addId(builder, DeviceId.pack(builder, _o.getId()));
        DeviceData.addCustomName(builder, _customName);
        DeviceData.addHardwareInfo(builder, _hardwareInfo);
        DeviceData.addHardwareStatus(builder, _hardwareStatus);
        DeviceData.addTrackers(builder, _trackers);
        return DeviceData.endDeviceData(builder);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public DeviceData get(int j) {
            return this.get(new DeviceData(), j);
        }

        public DeviceData get(DeviceData obj, int j) {
            return obj.__assign(DeviceData.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

