/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.data_feed.stay_aligned;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.data_feed.stay_aligned.StayAlignedTrackerT;

public final class StayAlignedTracker
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static StayAlignedTracker getRootAsStayAlignedTracker(ByteBuffer _bb) {
        return StayAlignedTracker.getRootAsStayAlignedTracker(_bb, new StayAlignedTracker());
    }

    public static StayAlignedTracker getRootAsStayAlignedTracker(ByteBuffer _bb, StayAlignedTracker obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public StayAlignedTracker __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public float yawCorrectionInDeg() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public float lockedErrorInDeg() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public float centerErrorInDeg() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public float neighborErrorInDeg() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public boolean locked() {
        int o = this.__offset(12);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public static int createStayAlignedTracker(FlatBufferBuilder builder, float yawCorrectionInDeg, float lockedErrorInDeg, float centerErrorInDeg, float neighborErrorInDeg, boolean locked) {
        builder.startTable(5);
        StayAlignedTracker.addNeighborErrorInDeg(builder, neighborErrorInDeg);
        StayAlignedTracker.addCenterErrorInDeg(builder, centerErrorInDeg);
        StayAlignedTracker.addLockedErrorInDeg(builder, lockedErrorInDeg);
        StayAlignedTracker.addYawCorrectionInDeg(builder, yawCorrectionInDeg);
        StayAlignedTracker.addLocked(builder, locked);
        return StayAlignedTracker.endStayAlignedTracker(builder);
    }

    public static void startStayAlignedTracker(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addYawCorrectionInDeg(FlatBufferBuilder builder, float yawCorrectionInDeg) {
        builder.addFloat(0, yawCorrectionInDeg, 0.0);
    }

    public static void addLockedErrorInDeg(FlatBufferBuilder builder, float lockedErrorInDeg) {
        builder.addFloat(1, lockedErrorInDeg, 0.0);
    }

    public static void addCenterErrorInDeg(FlatBufferBuilder builder, float centerErrorInDeg) {
        builder.addFloat(2, centerErrorInDeg, 0.0);
    }

    public static void addNeighborErrorInDeg(FlatBufferBuilder builder, float neighborErrorInDeg) {
        builder.addFloat(3, neighborErrorInDeg, 0.0);
    }

    public static void addLocked(FlatBufferBuilder builder, boolean locked) {
        builder.addBoolean(4, locked, false);
    }

    public static int endStayAlignedTracker(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public StayAlignedTrackerT unpack() {
        StayAlignedTrackerT _o = new StayAlignedTrackerT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(StayAlignedTrackerT _o) {
        float _oYawCorrectionInDeg = this.yawCorrectionInDeg();
        _o.setYawCorrectionInDeg(_oYawCorrectionInDeg);
        float _oLockedErrorInDeg = this.lockedErrorInDeg();
        _o.setLockedErrorInDeg(_oLockedErrorInDeg);
        float _oCenterErrorInDeg = this.centerErrorInDeg();
        _o.setCenterErrorInDeg(_oCenterErrorInDeg);
        float _oNeighborErrorInDeg = this.neighborErrorInDeg();
        _o.setNeighborErrorInDeg(_oNeighborErrorInDeg);
        boolean _oLocked = this.locked();
        _o.setLocked(_oLocked);
    }

    public static int pack(FlatBufferBuilder builder, StayAlignedTrackerT _o) {
        if (_o == null) {
            return 0;
        }
        return StayAlignedTracker.createStayAlignedTracker(builder, _o.getYawCorrectionInDeg(), _o.getLockedErrorInDeg(), _o.getCenterErrorInDeg(), _o.getNeighborErrorInDeg(), _o.getLocked());
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public StayAlignedTracker get(int j) {
            return this.get(new StayAlignedTracker(), j);
        }

        public StayAlignedTracker get(StayAlignedTracker obj, int j) {
            return obj.__assign(StayAlignedTracker.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

