/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.data_feed.tracker;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.data_feed.stay_aligned.StayAlignedTracker;
import solarxr_protocol.data_feed.tracker.TrackerDataT;
import solarxr_protocol.data_feed.tracker.TrackerInfo;
import solarxr_protocol.datatypes.Temperature;
import solarxr_protocol.datatypes.TrackerId;
import solarxr_protocol.datatypes.math.Quat;
import solarxr_protocol.datatypes.math.Vec3f;

public final class TrackerData
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static TrackerData getRootAsTrackerData(ByteBuffer _bb) {
        return TrackerData.getRootAsTrackerData(_bb, new TrackerData());
    }

    public static TrackerData getRootAsTrackerData(ByteBuffer _bb, TrackerData obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public TrackerData __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public TrackerId trackerId() {
        return this.trackerId(new TrackerId());
    }

    public TrackerId trackerId(TrackerId obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public TrackerInfo info() {
        return this.info(new TrackerInfo());
    }

    public TrackerInfo info(TrackerInfo obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public int status() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public Quat rotation() {
        return this.rotation(new Quat());
    }

    public Quat rotation(Quat obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public Vec3f position() {
        return this.position(new Vec3f());
    }

    public Vec3f position(Vec3f obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public Vec3f rawAngularVelocity() {
        return this.rawAngularVelocity(new Vec3f());
    }

    public Vec3f rawAngularVelocity(Vec3f obj) {
        int o = this.__offset(14);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public Vec3f rawAcceleration() {
        return this.rawAcceleration(new Vec3f());
    }

    public Vec3f rawAcceleration(Vec3f obj) {
        int o = this.__offset(16);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public Temperature temp() {
        return this.temp(new Temperature());
    }

    public Temperature temp(Temperature obj) {
        int o = this.__offset(18);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public Vec3f linearAcceleration() {
        return this.linearAcceleration(new Vec3f());
    }

    public Vec3f linearAcceleration(Vec3f obj) {
        int o = this.__offset(20);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public Quat rotationReferenceAdjusted() {
        return this.rotationReferenceAdjusted(new Quat());
    }

    public Quat rotationReferenceAdjusted(Quat obj) {
        int o = this.__offset(22);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public Quat rotationIdentityAdjusted() {
        return this.rotationIdentityAdjusted(new Quat());
    }

    public Quat rotationIdentityAdjusted(Quat obj) {
        int o = this.__offset(24);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public boolean hasTps() {
        return 0 != this.__offset(26);
    }

    public int tps() {
        int o = this.__offset(26);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public Vec3f rawMagneticVector() {
        return this.rawMagneticVector(new Vec3f());
    }

    public Vec3f rawMagneticVector(Vec3f obj) {
        int o = this.__offset(28);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public StayAlignedTracker stayAligned() {
        return this.stayAligned(new StayAlignedTracker());
    }

    public StayAlignedTracker stayAligned(StayAlignedTracker obj) {
        int o = this.__offset(30);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public static void startTrackerData(FlatBufferBuilder builder) {
        builder.startTable(14);
    }

    public static void addTrackerId(FlatBufferBuilder builder, int trackerIdOffset) {
        builder.addOffset(0, trackerIdOffset, 0);
    }

    public static void addInfo(FlatBufferBuilder builder, int infoOffset) {
        builder.addOffset(1, infoOffset, 0);
    }

    public static void addStatus(FlatBufferBuilder builder, int status) {
        builder.addByte(2, (byte)status, 0);
    }

    public static void addRotation(FlatBufferBuilder builder, int rotationOffset) {
        builder.addStruct(3, rotationOffset, 0);
    }

    public static void addPosition(FlatBufferBuilder builder, int positionOffset) {
        builder.addStruct(4, positionOffset, 0);
    }

    public static void addRawAngularVelocity(FlatBufferBuilder builder, int rawAngularVelocityOffset) {
        builder.addStruct(5, rawAngularVelocityOffset, 0);
    }

    public static void addRawAcceleration(FlatBufferBuilder builder, int rawAccelerationOffset) {
        builder.addStruct(6, rawAccelerationOffset, 0);
    }

    public static void addTemp(FlatBufferBuilder builder, int tempOffset) {
        builder.addStruct(7, tempOffset, 0);
    }

    public static void addLinearAcceleration(FlatBufferBuilder builder, int linearAccelerationOffset) {
        builder.addStruct(8, linearAccelerationOffset, 0);
    }

    public static void addRotationReferenceAdjusted(FlatBufferBuilder builder, int rotationReferenceAdjustedOffset) {
        builder.addStruct(9, rotationReferenceAdjustedOffset, 0);
    }

    public static void addRotationIdentityAdjusted(FlatBufferBuilder builder, int rotationIdentityAdjustedOffset) {
        builder.addStruct(10, rotationIdentityAdjustedOffset, 0);
    }

    public static void addTps(FlatBufferBuilder builder, int tps) {
        builder.addShort(11, (short)tps, 0);
    }

    public static void addRawMagneticVector(FlatBufferBuilder builder, int rawMagneticVectorOffset) {
        builder.addStruct(12, rawMagneticVectorOffset, 0);
    }

    public static void addStayAligned(FlatBufferBuilder builder, int stayAlignedOffset) {
        builder.addOffset(13, stayAlignedOffset, 0);
    }

    public static int endTrackerData(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public TrackerDataT unpack() {
        TrackerDataT _o = new TrackerDataT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(TrackerDataT _o) {
        if (this.trackerId() != null) {
            _o.setTrackerId(this.trackerId().unpack());
        } else {
            _o.setTrackerId(null);
        }
        if (this.info() != null) {
            _o.setInfo(this.info().unpack());
        } else {
            _o.setInfo(null);
        }
        int _oStatus = this.status();
        _o.setStatus(_oStatus);
        if (this.rotation() != null) {
            this.rotation().unpackTo(_o.getRotation());
        } else {
            _o.setRotation(null);
        }
        if (this.position() != null) {
            this.position().unpackTo(_o.getPosition());
        } else {
            _o.setPosition(null);
        }
        if (this.rawAngularVelocity() != null) {
            this.rawAngularVelocity().unpackTo(_o.getRawAngularVelocity());
        } else {
            _o.setRawAngularVelocity(null);
        }
        if (this.rawAcceleration() != null) {
            this.rawAcceleration().unpackTo(_o.getRawAcceleration());
        } else {
            _o.setRawAcceleration(null);
        }
        if (this.temp() != null) {
            this.temp().unpackTo(_o.getTemp());
        } else {
            _o.setTemp(null);
        }
        if (this.linearAcceleration() != null) {
            this.linearAcceleration().unpackTo(_o.getLinearAcceleration());
        } else {
            _o.setLinearAcceleration(null);
        }
        if (this.rotationReferenceAdjusted() != null) {
            this.rotationReferenceAdjusted().unpackTo(_o.getRotationReferenceAdjusted());
        } else {
            _o.setRotationReferenceAdjusted(null);
        }
        if (this.rotationIdentityAdjusted() != null) {
            this.rotationIdentityAdjusted().unpackTo(_o.getRotationIdentityAdjusted());
        } else {
            _o.setRotationIdentityAdjusted(null);
        }
        Integer _oTps = this.hasTps() ? Integer.valueOf(this.tps()) : null;
        _o.setTps(_oTps);
        if (this.rawMagneticVector() != null) {
            this.rawMagneticVector().unpackTo(_o.getRawMagneticVector());
        } else {
            _o.setRawMagneticVector(null);
        }
        if (this.stayAligned() != null) {
            _o.setStayAligned(this.stayAligned().unpack());
        } else {
            _o.setStayAligned(null);
        }
    }

    public static int pack(FlatBufferBuilder builder, TrackerDataT _o) {
        if (_o == null) {
            return 0;
        }
        int _trackerId = _o.getTrackerId() == null ? 0 : TrackerId.pack(builder, _o.getTrackerId());
        int _info = _o.getInfo() == null ? 0 : TrackerInfo.pack(builder, _o.getInfo());
        int _stayAligned = _o.getStayAligned() == null ? 0 : StayAlignedTracker.pack(builder, _o.getStayAligned());
        TrackerData.startTrackerData(builder);
        TrackerData.addTrackerId(builder, _trackerId);
        TrackerData.addInfo(builder, _info);
        TrackerData.addStatus(builder, _o.getStatus());
        TrackerData.addRotation(builder, Quat.pack(builder, _o.getRotation()));
        TrackerData.addPosition(builder, Vec3f.pack(builder, _o.getPosition()));
        TrackerData.addRawAngularVelocity(builder, Vec3f.pack(builder, _o.getRawAngularVelocity()));
        TrackerData.addRawAcceleration(builder, Vec3f.pack(builder, _o.getRawAcceleration()));
        TrackerData.addTemp(builder, Temperature.pack(builder, _o.getTemp()));
        TrackerData.addLinearAcceleration(builder, Vec3f.pack(builder, _o.getLinearAcceleration()));
        TrackerData.addRotationReferenceAdjusted(builder, Quat.pack(builder, _o.getRotationReferenceAdjusted()));
        TrackerData.addRotationIdentityAdjusted(builder, Quat.pack(builder, _o.getRotationIdentityAdjusted()));
        if (_o.getTps() != null) {
            TrackerData.addTps(builder, _o.getTps());
        }
        TrackerData.addRawMagneticVector(builder, Vec3f.pack(builder, _o.getRawMagneticVector()));
        TrackerData.addStayAligned(builder, _stayAligned);
        return TrackerData.endTrackerData(builder);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public TrackerData get(int j) {
            return this.get(new TrackerData(), j);
        }

        public TrackerData get(TrackerData obj, int j) {
            return obj.__assign(TrackerData.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

