/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.data_feed.tracker;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.data_feed.tracker.TrackerInfoT;
import solarxr_protocol.datatypes.HzF32;
import solarxr_protocol.datatypes.math.Quat;

public final class TrackerInfo
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static TrackerInfo getRootAsTrackerInfo(ByteBuffer _bb) {
        return TrackerInfo.getRootAsTrackerInfo(_bb, new TrackerInfo());
    }

    public static TrackerInfo getRootAsTrackerInfo(ByteBuffer _bb, TrackerInfo obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public TrackerInfo __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int imuType() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public int bodyPart() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public HzF32 pollRate() {
        return this.pollRate(new HzF32());
    }

    public HzF32 pollRate(HzF32 obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public Quat mountingOrientation() {
        return this.mountingOrientation(new Quat());
    }

    public Quat mountingOrientation(Quat obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public boolean editable() {
        int o = this.__offset(12);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean isComputed() {
        int o = this.__offset(14);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean isImu() {
        int o = this.__offset(16);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public String displayName() {
        int o = this.__offset(18);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer displayNameAsByteBuffer() {
        return this.__vector_as_bytebuffer(18, 1);
    }

    public ByteBuffer displayNameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 18, 1);
    }

    public String customName() {
        int o = this.__offset(20);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer customNameAsByteBuffer() {
        return this.__vector_as_bytebuffer(20, 1);
    }

    public ByteBuffer customNameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 20, 1);
    }

    public boolean allowDriftCompensation() {
        int o = this.__offset(22);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public Quat mountingResetOrientation() {
        return this.mountingResetOrientation(new Quat());
    }

    public Quat mountingResetOrientation(Quat obj) {
        int o = this.__offset(24);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public boolean isHmd() {
        int o = this.__offset(26);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public int magnetometer() {
        int o = this.__offset(28);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public int dataSupport() {
        int o = this.__offset(30);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public static void startTrackerInfo(FlatBufferBuilder builder) {
        builder.startTable(14);
    }

    public static void addImuType(FlatBufferBuilder builder, int imuType) {
        builder.addShort(0, (short)imuType, 0);
    }

    public static void addBodyPart(FlatBufferBuilder builder, int bodyPart) {
        builder.addByte(1, (byte)bodyPart, 0);
    }

    public static void addPollRate(FlatBufferBuilder builder, int pollRateOffset) {
        builder.addStruct(2, pollRateOffset, 0);
    }

    public static void addMountingOrientation(FlatBufferBuilder builder, int mountingOrientationOffset) {
        builder.addStruct(3, mountingOrientationOffset, 0);
    }

    public static void addEditable(FlatBufferBuilder builder, boolean editable) {
        builder.addBoolean(4, editable, false);
    }

    public static void addIsComputed(FlatBufferBuilder builder, boolean isComputed) {
        builder.addBoolean(5, isComputed, false);
    }

    public static void addIsImu(FlatBufferBuilder builder, boolean isImu) {
        builder.addBoolean(6, isImu, false);
    }

    public static void addDisplayName(FlatBufferBuilder builder, int displayNameOffset) {
        builder.addOffset(7, displayNameOffset, 0);
    }

    public static void addCustomName(FlatBufferBuilder builder, int customNameOffset) {
        builder.addOffset(8, customNameOffset, 0);
    }

    public static void addAllowDriftCompensation(FlatBufferBuilder builder, boolean allowDriftCompensation) {
        builder.addBoolean(9, allowDriftCompensation, false);
    }

    public static void addMountingResetOrientation(FlatBufferBuilder builder, int mountingResetOrientationOffset) {
        builder.addStruct(10, mountingResetOrientationOffset, 0);
    }

    public static void addIsHmd(FlatBufferBuilder builder, boolean isHmd) {
        builder.addBoolean(11, isHmd, false);
    }

    public static void addMagnetometer(FlatBufferBuilder builder, int magnetometer) {
        builder.addByte(12, (byte)magnetometer, 0);
    }

    public static void addDataSupport(FlatBufferBuilder builder, int dataSupport) {
        builder.addByte(13, (byte)dataSupport, 0);
    }

    public static int endTrackerInfo(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public TrackerInfoT unpack() {
        TrackerInfoT _o = new TrackerInfoT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(TrackerInfoT _o) {
        int _oImuType = this.imuType();
        _o.setImuType(_oImuType);
        int _oBodyPart = this.bodyPart();
        _o.setBodyPart(_oBodyPart);
        if (this.pollRate() != null) {
            this.pollRate().unpackTo(_o.getPollRate());
        } else {
            _o.setPollRate(null);
        }
        if (this.mountingOrientation() != null) {
            this.mountingOrientation().unpackTo(_o.getMountingOrientation());
        } else {
            _o.setMountingOrientation(null);
        }
        boolean _oEditable = this.editable();
        _o.setEditable(_oEditable);
        boolean _oIsComputed = this.isComputed();
        _o.setIsComputed(_oIsComputed);
        boolean _oIsImu = this.isImu();
        _o.setIsImu(_oIsImu);
        String _oDisplayName = this.displayName();
        _o.setDisplayName(_oDisplayName);
        String _oCustomName = this.customName();
        _o.setCustomName(_oCustomName);
        boolean _oAllowDriftCompensation = this.allowDriftCompensation();
        _o.setAllowDriftCompensation(_oAllowDriftCompensation);
        if (this.mountingResetOrientation() != null) {
            this.mountingResetOrientation().unpackTo(_o.getMountingResetOrientation());
        } else {
            _o.setMountingResetOrientation(null);
        }
        boolean _oIsHmd = this.isHmd();
        _o.setIsHmd(_oIsHmd);
        int _oMagnetometer = this.magnetometer();
        _o.setMagnetometer(_oMagnetometer);
        int _oDataSupport = this.dataSupport();
        _o.setDataSupport(_oDataSupport);
    }

    public static int pack(FlatBufferBuilder builder, TrackerInfoT _o) {
        if (_o == null) {
            return 0;
        }
        int _displayName = _o.getDisplayName() == null ? 0 : builder.createString(_o.getDisplayName());
        int _customName = _o.getCustomName() == null ? 0 : builder.createString(_o.getCustomName());
        TrackerInfo.startTrackerInfo(builder);
        TrackerInfo.addImuType(builder, _o.getImuType());
        TrackerInfo.addBodyPart(builder, _o.getBodyPart());
        TrackerInfo.addPollRate(builder, HzF32.pack(builder, _o.getPollRate()));
        TrackerInfo.addMountingOrientation(builder, Quat.pack(builder, _o.getMountingOrientation()));
        TrackerInfo.addEditable(builder, _o.getEditable());
        TrackerInfo.addIsComputed(builder, _o.getIsComputed());
        TrackerInfo.addIsImu(builder, _o.getIsImu());
        TrackerInfo.addDisplayName(builder, _displayName);
        TrackerInfo.addCustomName(builder, _customName);
        TrackerInfo.addAllowDriftCompensation(builder, _o.getAllowDriftCompensation());
        TrackerInfo.addMountingResetOrientation(builder, Quat.pack(builder, _o.getMountingResetOrientation()));
        TrackerInfo.addIsHmd(builder, _o.getIsHmd());
        TrackerInfo.addMagnetometer(builder, _o.getMagnetometer());
        TrackerInfo.addDataSupport(builder, _o.getDataSupport());
        return TrackerInfo.endTrackerInfo(builder);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public TrackerInfo get(int j) {
            return this.get(new TrackerInfo(), j);
        }

        public TrackerInfo get(TrackerInfo obj, int j) {
            return obj.__assign(TrackerInfo.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

