/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.datatypes.hardware_info;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.datatypes.Ipv4Address;
import solarxr_protocol.datatypes.hardware_info.HardwareAddress;
import solarxr_protocol.datatypes.hardware_info.HardwareInfoT;

public final class HardwareInfo
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static HardwareInfo getRootAsHardwareInfo(ByteBuffer _bb) {
        return HardwareInfo.getRootAsHardwareInfo(_bb, new HardwareInfo());
    }

    public static HardwareInfo getRootAsHardwareInfo(ByteBuffer _bb, HardwareInfo obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public HardwareInfo __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int mcuId() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public String displayName() {
        int o = this.__offset(6);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer displayNameAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public ByteBuffer displayNameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 1);
    }

    public String model() {
        int o = this.__offset(8);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer modelAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 1);
    }

    public ByteBuffer modelInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 1);
    }

    public String manufacturer() {
        int o = this.__offset(10);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer manufacturerAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 1);
    }

    public ByteBuffer manufacturerInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 1);
    }

    public String hardwareRevision() {
        int o = this.__offset(12);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer hardwareRevisionAsByteBuffer() {
        return this.__vector_as_bytebuffer(12, 1);
    }

    public ByteBuffer hardwareRevisionInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 12, 1);
    }

    public String firmwareVersion() {
        int o = this.__offset(14);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer firmwareVersionAsByteBuffer() {
        return this.__vector_as_bytebuffer(14, 1);
    }

    public ByteBuffer firmwareVersionInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 14, 1);
    }

    public HardwareAddress hardwareAddress() {
        return this.hardwareAddress(new HardwareAddress());
    }

    public HardwareAddress hardwareAddress(HardwareAddress obj) {
        int o = this.__offset(16);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public Ipv4Address ipAddress() {
        return this.ipAddress(new Ipv4Address());
    }

    public Ipv4Address ipAddress(Ipv4Address obj) {
        int o = this.__offset(18);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public String boardType() {
        int o = this.__offset(20);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer boardTypeAsByteBuffer() {
        return this.__vector_as_bytebuffer(20, 1);
    }

    public ByteBuffer boardTypeInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 20, 1);
    }

    public int officialBoardType() {
        int o = this.__offset(22);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public String hardwareIdentifier() {
        int o = this.__offset(24);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer hardwareIdentifierAsByteBuffer() {
        return this.__vector_as_bytebuffer(24, 1);
    }

    public ByteBuffer hardwareIdentifierInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 24, 1);
    }

    public boolean hasNetworkProtocolVersion() {
        return 0 != this.__offset(26);
    }

    public int networkProtocolVersion() {
        int o = this.__offset(26);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public static void startHardwareInfo(FlatBufferBuilder builder) {
        builder.startTable(12);
    }

    public static void addMcuId(FlatBufferBuilder builder, int mcuId) {
        builder.addShort(0, (short)mcuId, 0);
    }

    public static void addDisplayName(FlatBufferBuilder builder, int displayNameOffset) {
        builder.addOffset(1, displayNameOffset, 0);
    }

    public static void addModel(FlatBufferBuilder builder, int modelOffset) {
        builder.addOffset(2, modelOffset, 0);
    }

    public static void addManufacturer(FlatBufferBuilder builder, int manufacturerOffset) {
        builder.addOffset(3, manufacturerOffset, 0);
    }

    public static void addHardwareRevision(FlatBufferBuilder builder, int hardwareRevisionOffset) {
        builder.addOffset(4, hardwareRevisionOffset, 0);
    }

    public static void addFirmwareVersion(FlatBufferBuilder builder, int firmwareVersionOffset) {
        builder.addOffset(5, firmwareVersionOffset, 0);
    }

    public static void addHardwareAddress(FlatBufferBuilder builder, int hardwareAddressOffset) {
        builder.addStruct(6, hardwareAddressOffset, 0);
    }

    public static void addIpAddress(FlatBufferBuilder builder, int ipAddressOffset) {
        builder.addStruct(7, ipAddressOffset, 0);
    }

    public static void addBoardType(FlatBufferBuilder builder, int boardTypeOffset) {
        builder.addOffset(8, boardTypeOffset, 0);
    }

    public static void addOfficialBoardType(FlatBufferBuilder builder, int officialBoardType) {
        builder.addShort(9, (short)officialBoardType, 0);
    }

    public static void addHardwareIdentifier(FlatBufferBuilder builder, int hardwareIdentifierOffset) {
        builder.addOffset(10, hardwareIdentifierOffset, 0);
    }

    public static void addNetworkProtocolVersion(FlatBufferBuilder builder, int networkProtocolVersion) {
        builder.addShort(11, (short)networkProtocolVersion, 0);
    }

    public static int endHardwareInfo(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public HardwareInfoT unpack() {
        HardwareInfoT _o = new HardwareInfoT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(HardwareInfoT _o) {
        int _oMcuId = this.mcuId();
        _o.setMcuId(_oMcuId);
        String _oDisplayName = this.displayName();
        _o.setDisplayName(_oDisplayName);
        String _oModel = this.model();
        _o.setModel(_oModel);
        String _oManufacturer = this.manufacturer();
        _o.setManufacturer(_oManufacturer);
        String _oHardwareRevision = this.hardwareRevision();
        _o.setHardwareRevision(_oHardwareRevision);
        String _oFirmwareVersion = this.firmwareVersion();
        _o.setFirmwareVersion(_oFirmwareVersion);
        if (this.hardwareAddress() != null) {
            this.hardwareAddress().unpackTo(_o.getHardwareAddress());
        } else {
            _o.setHardwareAddress(null);
        }
        if (this.ipAddress() != null) {
            this.ipAddress().unpackTo(_o.getIpAddress());
        } else {
            _o.setIpAddress(null);
        }
        String _oBoardType = this.boardType();
        _o.setBoardType(_oBoardType);
        int _oOfficialBoardType = this.officialBoardType();
        _o.setOfficialBoardType(_oOfficialBoardType);
        String _oHardwareIdentifier = this.hardwareIdentifier();
        _o.setHardwareIdentifier(_oHardwareIdentifier);
        Integer _oNetworkProtocolVersion = this.hasNetworkProtocolVersion() ? Integer.valueOf(this.networkProtocolVersion()) : null;
        _o.setNetworkProtocolVersion(_oNetworkProtocolVersion);
    }

    public static int pack(FlatBufferBuilder builder, HardwareInfoT _o) {
        if (_o == null) {
            return 0;
        }
        int _displayName = _o.getDisplayName() == null ? 0 : builder.createString(_o.getDisplayName());
        int _model = _o.getModel() == null ? 0 : builder.createString(_o.getModel());
        int _manufacturer = _o.getManufacturer() == null ? 0 : builder.createString(_o.getManufacturer());
        int _hardwareRevision = _o.getHardwareRevision() == null ? 0 : builder.createString(_o.getHardwareRevision());
        int _firmwareVersion = _o.getFirmwareVersion() == null ? 0 : builder.createString(_o.getFirmwareVersion());
        int _boardType = _o.getBoardType() == null ? 0 : builder.createString(_o.getBoardType());
        int _hardwareIdentifier = _o.getHardwareIdentifier() == null ? 0 : builder.createString(_o.getHardwareIdentifier());
        HardwareInfo.startHardwareInfo(builder);
        HardwareInfo.addMcuId(builder, _o.getMcuId());
        HardwareInfo.addDisplayName(builder, _displayName);
        HardwareInfo.addModel(builder, _model);
        HardwareInfo.addManufacturer(builder, _manufacturer);
        HardwareInfo.addHardwareRevision(builder, _hardwareRevision);
        HardwareInfo.addFirmwareVersion(builder, _firmwareVersion);
        HardwareInfo.addHardwareAddress(builder, HardwareAddress.pack(builder, _o.getHardwareAddress()));
        HardwareInfo.addIpAddress(builder, Ipv4Address.pack(builder, _o.getIpAddress()));
        HardwareInfo.addBoardType(builder, _boardType);
        HardwareInfo.addOfficialBoardType(builder, _o.getOfficialBoardType());
        HardwareInfo.addHardwareIdentifier(builder, _hardwareIdentifier);
        if (_o.getNetworkProtocolVersion() != null) {
            HardwareInfo.addNetworkProtocolVersion(builder, _o.getNetworkProtocolVersion());
        }
        return HardwareInfo.endHardwareInfo(builder);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public HardwareInfo get(int j) {
            return this.get(new HardwareInfo(), j);
        }

        public HardwareInfo get(HardwareInfo obj, int j) {
            return obj.__assign(HardwareInfo.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

