/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.datatypes.hardware_info;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.datatypes.LogData;
import solarxr_protocol.datatypes.hardware_info.HardwareStatusT;

public final class HardwareStatus
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static HardwareStatus getRootAsHardwareStatus(ByteBuffer _bb) {
        return HardwareStatus.getRootAsHardwareStatus(_bb, new HardwareStatus());
    }

    public static HardwareStatus getRootAsHardwareStatus(ByteBuffer _bb, HardwareStatus obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public HardwareStatus __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public boolean hasErrorStatus() {
        return 0 != this.__offset(4);
    }

    public int errorStatus() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public boolean hasPing() {
        return 0 != this.__offset(8);
    }

    public int ping() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public boolean hasRssi() {
        return 0 != this.__offset(10);
    }

    public short rssi() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) : (short)0;
    }

    public boolean hasMcuTemp() {
        return 0 != this.__offset(12);
    }

    public float mcuTemp() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public boolean hasBatteryVoltage() {
        return 0 != this.__offset(14);
    }

    public float batteryVoltage() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public boolean hasBatteryPctEstimate() {
        return 0 != this.__offset(16);
    }

    public int batteryPctEstimate() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public LogData logData() {
        return this.logData(new LogData());
    }

    public LogData logData(LogData obj) {
        int o = this.__offset(18);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public static int createHardwareStatus(FlatBufferBuilder builder, int errorStatus, int ping, short rssi, float mcuTemp, float batteryVoltage, int batteryPctEstimate, int logDataOffset) {
        builder.startTable(8);
        HardwareStatus.addLogData(builder, logDataOffset);
        HardwareStatus.addBatteryVoltage(builder, batteryVoltage);
        HardwareStatus.addMcuTemp(builder, mcuTemp);
        HardwareStatus.addRssi(builder, rssi);
        HardwareStatus.addPing(builder, ping);
        HardwareStatus.addBatteryPctEstimate(builder, batteryPctEstimate);
        HardwareStatus.addErrorStatus(builder, errorStatus);
        return HardwareStatus.endHardwareStatus(builder);
    }

    public static void startHardwareStatus(FlatBufferBuilder builder) {
        builder.startTable(8);
    }

    public static void addErrorStatus(FlatBufferBuilder builder, int errorStatus) {
        builder.addByte(0, (byte)errorStatus, 0);
    }

    public static void addPing(FlatBufferBuilder builder, int ping) {
        builder.addShort(2, (short)ping, 0);
    }

    public static void addRssi(FlatBufferBuilder builder, short rssi) {
        builder.addShort(3, rssi, 0);
    }

    public static void addMcuTemp(FlatBufferBuilder builder, float mcuTemp) {
        builder.addFloat(4, mcuTemp, 0.0);
    }

    public static void addBatteryVoltage(FlatBufferBuilder builder, float batteryVoltage) {
        builder.addFloat(5, batteryVoltage, 0.0);
    }

    public static void addBatteryPctEstimate(FlatBufferBuilder builder, int batteryPctEstimate) {
        builder.addByte(6, (byte)batteryPctEstimate, 0);
    }

    public static void addLogData(FlatBufferBuilder builder, int logDataOffset) {
        builder.addOffset(7, logDataOffset, 0);
    }

    public static int endHardwareStatus(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public HardwareStatusT unpack() {
        HardwareStatusT _o = new HardwareStatusT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(HardwareStatusT _o) {
        Integer _oErrorStatus = this.hasErrorStatus() ? Integer.valueOf(this.errorStatus()) : null;
        _o.setErrorStatus(_oErrorStatus);
        Integer _oPing = this.hasPing() ? Integer.valueOf(this.ping()) : null;
        _o.setPing(_oPing);
        Short _oRssi = this.hasRssi() ? Short.valueOf(this.rssi()) : null;
        _o.setRssi(_oRssi);
        Float _oMcuTemp = this.hasMcuTemp() ? Float.valueOf(this.mcuTemp()) : null;
        _o.setMcuTemp(_oMcuTemp);
        Float _oBatteryVoltage = this.hasBatteryVoltage() ? Float.valueOf(this.batteryVoltage()) : null;
        _o.setBatteryVoltage(_oBatteryVoltage);
        Integer _oBatteryPctEstimate = this.hasBatteryPctEstimate() ? Integer.valueOf(this.batteryPctEstimate()) : null;
        _o.setBatteryPctEstimate(_oBatteryPctEstimate);
        if (this.logData() != null) {
            _o.setLogData(this.logData().unpack());
        } else {
            _o.setLogData(null);
        }
    }

    public static int pack(FlatBufferBuilder builder, HardwareStatusT _o) {
        if (_o == null) {
            return 0;
        }
        int _logData = _o.getLogData() == null ? 0 : LogData.pack(builder, _o.getLogData());
        return HardwareStatus.createHardwareStatus(builder, _o.getErrorStatus(), _o.getPing(), _o.getRssi(), _o.getMcuTemp().floatValue(), _o.getBatteryVoltage().floatValue(), _o.getBatteryPctEstimate(), _logData);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public HardwareStatus get(int j) {
            return this.get(new HardwareStatus(), j);
        }

        public HardwareStatus get(HardwareStatus obj, int j) {
            return obj.__assign(HardwareStatus.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

