/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.rpc;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.rpc.OSCSettingsT;

public final class OSCSettings
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static OSCSettings getRootAsOSCSettings(ByteBuffer _bb) {
        return OSCSettings.getRootAsOSCSettings(_bb, new OSCSettings());
    }

    public static OSCSettings getRootAsOSCSettings(ByteBuffer _bb, OSCSettings obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public OSCSettings __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public boolean enabled() {
        int o = this.__offset(4);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public int portIn() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public int portOut() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public String address() {
        int o = this.__offset(10);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer addressAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 1);
    }

    public ByteBuffer addressInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 1);
    }

    public static int createOSCSettings(FlatBufferBuilder builder, boolean enabled, int portIn, int portOut, int addressOffset) {
        builder.startTable(4);
        OSCSettings.addAddress(builder, addressOffset);
        OSCSettings.addPortOut(builder, portOut);
        OSCSettings.addPortIn(builder, portIn);
        OSCSettings.addEnabled(builder, enabled);
        return OSCSettings.endOSCSettings(builder);
    }

    public static void startOSCSettings(FlatBufferBuilder builder) {
        builder.startTable(4);
    }

    public static void addEnabled(FlatBufferBuilder builder, boolean enabled) {
        builder.addBoolean(0, enabled, false);
    }

    public static void addPortIn(FlatBufferBuilder builder, int portIn) {
        builder.addShort(1, (short)portIn, 0);
    }

    public static void addPortOut(FlatBufferBuilder builder, int portOut) {
        builder.addShort(2, (short)portOut, 0);
    }

    public static void addAddress(FlatBufferBuilder builder, int addressOffset) {
        builder.addOffset(3, addressOffset, 0);
    }

    public static int endOSCSettings(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public OSCSettingsT unpack() {
        OSCSettingsT _o = new OSCSettingsT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(OSCSettingsT _o) {
        boolean _oEnabled = this.enabled();
        _o.setEnabled(_oEnabled);
        int _oPortIn = this.portIn();
        _o.setPortIn(_oPortIn);
        int _oPortOut = this.portOut();
        _o.setPortOut(_oPortOut);
        String _oAddress = this.address();
        _o.setAddress(_oAddress);
    }

    public static int pack(FlatBufferBuilder builder, OSCSettingsT _o) {
        if (_o == null) {
            return 0;
        }
        int _address = _o.getAddress() == null ? 0 : builder.createString(_o.getAddress());
        return OSCSettings.createOSCSettings(builder, _o.getEnabled(), _o.getPortIn(), _o.getPortOut(), _address);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public OSCSettings get(int j) {
            return this.get(new OSCSettings(), j);
        }

        public OSCSettings get(OSCSettings obj, int j) {
            return obj.__assign(OSCSettings.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

