/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.rpc;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.rpc.FirmwarePart;
import solarxr_protocol.rpc.FirmwarePartT;
import solarxr_protocol.rpc.SerialDevicePort;
import solarxr_protocol.rpc.SerialFirmwareUpdateT;

public final class SerialFirmwareUpdate
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static SerialFirmwareUpdate getRootAsSerialFirmwareUpdate(ByteBuffer _bb) {
        return SerialFirmwareUpdate.getRootAsSerialFirmwareUpdate(_bb, new SerialFirmwareUpdate());
    }

    public static SerialFirmwareUpdate getRootAsSerialFirmwareUpdate(ByteBuffer _bb, SerialFirmwareUpdate obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public SerialFirmwareUpdate __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public SerialDevicePort deviceId() {
        return this.deviceId(new SerialDevicePort());
    }

    public SerialDevicePort deviceId(SerialDevicePort obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public boolean needManualReboot() {
        int o = this.__offset(6);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public String ssid() {
        int o = this.__offset(8);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer ssidAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 1);
    }

    public ByteBuffer ssidInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 1);
    }

    public String password() {
        int o = this.__offset(10);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer passwordAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 1);
    }

    public ByteBuffer passwordInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 1);
    }

    public FirmwarePart firmwarePart(int j) {
        return this.firmwarePart(new FirmwarePart(), j);
    }

    public FirmwarePart firmwarePart(FirmwarePart obj, int j) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int firmwarePartLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public FirmwarePart.Vector firmwarePartVector() {
        return this.firmwarePartVector(new FirmwarePart.Vector());
    }

    public FirmwarePart.Vector firmwarePartVector(FirmwarePart.Vector obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public static int createSerialFirmwareUpdate(FlatBufferBuilder builder, int deviceIdOffset, boolean needManualReboot, int ssidOffset, int passwordOffset, int firmwarePartOffset) {
        builder.startTable(5);
        SerialFirmwareUpdate.addFirmwarePart(builder, firmwarePartOffset);
        SerialFirmwareUpdate.addPassword(builder, passwordOffset);
        SerialFirmwareUpdate.addSsid(builder, ssidOffset);
        SerialFirmwareUpdate.addDeviceId(builder, deviceIdOffset);
        SerialFirmwareUpdate.addNeedManualReboot(builder, needManualReboot);
        return SerialFirmwareUpdate.endSerialFirmwareUpdate(builder);
    }

    public static void startSerialFirmwareUpdate(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addDeviceId(FlatBufferBuilder builder, int deviceIdOffset) {
        builder.addOffset(0, deviceIdOffset, 0);
    }

    public static void addNeedManualReboot(FlatBufferBuilder builder, boolean needManualReboot) {
        builder.addBoolean(1, needManualReboot, false);
    }

    public static void addSsid(FlatBufferBuilder builder, int ssidOffset) {
        builder.addOffset(2, ssidOffset, 0);
    }

    public static void addPassword(FlatBufferBuilder builder, int passwordOffset) {
        builder.addOffset(3, passwordOffset, 0);
    }

    public static void addFirmwarePart(FlatBufferBuilder builder, int firmwarePartOffset) {
        builder.addOffset(4, firmwarePartOffset, 0);
    }

    public static int createFirmwarePartVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startFirmwarePartVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endSerialFirmwareUpdate(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public SerialFirmwareUpdateT unpack() {
        SerialFirmwareUpdateT _o = new SerialFirmwareUpdateT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(SerialFirmwareUpdateT _o) {
        if (this.deviceId() != null) {
            _o.setDeviceId(this.deviceId().unpack());
        } else {
            _o.setDeviceId(null);
        }
        boolean _oNeedManualReboot = this.needManualReboot();
        _o.setNeedManualReboot(_oNeedManualReboot);
        String _oSsid = this.ssid();
        _o.setSsid(_oSsid);
        String _oPassword = this.password();
        _o.setPassword(_oPassword);
        FirmwarePartT[] _oFirmwarePart = new FirmwarePartT[this.firmwarePartLength()];
        for (int _j = 0; _j < this.firmwarePartLength(); ++_j) {
            _oFirmwarePart[_j] = this.firmwarePart(_j) != null ? this.firmwarePart(_j).unpack() : null;
        }
        _o.setFirmwarePart(_oFirmwarePart);
    }

    public static int pack(FlatBufferBuilder builder, SerialFirmwareUpdateT _o) {
        if (_o == null) {
            return 0;
        }
        int _deviceId = _o.getDeviceId() == null ? 0 : SerialDevicePort.pack(builder, _o.getDeviceId());
        int _ssid = _o.getSsid() == null ? 0 : builder.createString(_o.getSsid());
        int _password = _o.getPassword() == null ? 0 : builder.createString(_o.getPassword());
        int _firmwarePart = 0;
        if (_o.getFirmwarePart() != null) {
            int[] __firmwarePart = new int[_o.getFirmwarePart().length];
            int _j = 0;
            for (FirmwarePartT _e : _o.getFirmwarePart()) {
                __firmwarePart[_j] = FirmwarePart.pack(builder, _e);
                ++_j;
            }
            _firmwarePart = SerialFirmwareUpdate.createFirmwarePartVector(builder, __firmwarePart);
        }
        return SerialFirmwareUpdate.createSerialFirmwareUpdate(builder, _deviceId, _o.getNeedManualReboot(), _ssid, _password, _firmwarePart);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public SerialFirmwareUpdate get(int j) {
            return this.get(new SerialFirmwareUpdate(), j);
        }

        public SerialFirmwareUpdate get(SerialFirmwareUpdate obj, int j) {
            return obj.__assign(SerialFirmwareUpdate.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

