/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.rpc;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.rpc.TapDetectionSettingsT;

public final class TapDetectionSettings
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static TapDetectionSettings getRootAsTapDetectionSettings(ByteBuffer _bb) {
        return TapDetectionSettings.getRootAsTapDetectionSettings(_bb, new TapDetectionSettings());
    }

    public static TapDetectionSettings getRootAsTapDetectionSettings(ByteBuffer _bb, TapDetectionSettings obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public TapDetectionSettings __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public boolean hasFullResetDelay() {
        return 0 != this.__offset(4);
    }

    public float fullResetDelay() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public boolean hasFullResetEnabled() {
        return 0 != this.__offset(6);
    }

    public boolean fullResetEnabled() {
        int o = this.__offset(6);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean hasFullResetTaps() {
        return 0 != this.__offset(8);
    }

    public int fullResetTaps() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public boolean hasYawResetDelay() {
        return 0 != this.__offset(10);
    }

    public float yawResetDelay() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public boolean hasYawResetEnabled() {
        return 0 != this.__offset(12);
    }

    public boolean yawResetEnabled() {
        int o = this.__offset(12);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean hasYawResetTaps() {
        return 0 != this.__offset(14);
    }

    public int yawResetTaps() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public boolean hasMountingResetDelay() {
        return 0 != this.__offset(16);
    }

    public float mountingResetDelay() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public boolean hasMountingResetEnabled() {
        return 0 != this.__offset(18);
    }

    public boolean mountingResetEnabled() {
        int o = this.__offset(18);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean hasMountingResetTaps() {
        return 0 != this.__offset(20);
    }

    public int mountingResetTaps() {
        int o = this.__offset(20);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public boolean hasSetupMode() {
        return 0 != this.__offset(22);
    }

    public boolean setupMode() {
        int o = this.__offset(22);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean hasNumberTrackersOverThreshold() {
        return 0 != this.__offset(24);
    }

    public int numberTrackersOverThreshold() {
        int o = this.__offset(24);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public static int createTapDetectionSettings(FlatBufferBuilder builder, float fullResetDelay, boolean fullResetEnabled, int fullResetTaps, float yawResetDelay, boolean yawResetEnabled, int yawResetTaps, float mountingResetDelay, boolean mountingResetEnabled, int mountingResetTaps, boolean setupMode, int numberTrackersOverThreshold) {
        builder.startTable(11);
        TapDetectionSettings.addMountingResetDelay(builder, mountingResetDelay);
        TapDetectionSettings.addYawResetDelay(builder, yawResetDelay);
        TapDetectionSettings.addFullResetDelay(builder, fullResetDelay);
        TapDetectionSettings.addNumberTrackersOverThreshold(builder, numberTrackersOverThreshold);
        TapDetectionSettings.addSetupMode(builder, setupMode);
        TapDetectionSettings.addMountingResetTaps(builder, mountingResetTaps);
        TapDetectionSettings.addMountingResetEnabled(builder, mountingResetEnabled);
        TapDetectionSettings.addYawResetTaps(builder, yawResetTaps);
        TapDetectionSettings.addYawResetEnabled(builder, yawResetEnabled);
        TapDetectionSettings.addFullResetTaps(builder, fullResetTaps);
        TapDetectionSettings.addFullResetEnabled(builder, fullResetEnabled);
        return TapDetectionSettings.endTapDetectionSettings(builder);
    }

    public static void startTapDetectionSettings(FlatBufferBuilder builder) {
        builder.startTable(11);
    }

    public static void addFullResetDelay(FlatBufferBuilder builder, float fullResetDelay) {
        builder.addFloat(0, fullResetDelay, 0.0);
    }

    public static void addFullResetEnabled(FlatBufferBuilder builder, boolean fullResetEnabled) {
        builder.addBoolean(1, fullResetEnabled, false);
    }

    public static void addFullResetTaps(FlatBufferBuilder builder, int fullResetTaps) {
        builder.addByte(2, (byte)fullResetTaps, 0);
    }

    public static void addYawResetDelay(FlatBufferBuilder builder, float yawResetDelay) {
        builder.addFloat(3, yawResetDelay, 0.0);
    }

    public static void addYawResetEnabled(FlatBufferBuilder builder, boolean yawResetEnabled) {
        builder.addBoolean(4, yawResetEnabled, false);
    }

    public static void addYawResetTaps(FlatBufferBuilder builder, int yawResetTaps) {
        builder.addByte(5, (byte)yawResetTaps, 0);
    }

    public static void addMountingResetDelay(FlatBufferBuilder builder, float mountingResetDelay) {
        builder.addFloat(6, mountingResetDelay, 0.0);
    }

    public static void addMountingResetEnabled(FlatBufferBuilder builder, boolean mountingResetEnabled) {
        builder.addBoolean(7, mountingResetEnabled, false);
    }

    public static void addMountingResetTaps(FlatBufferBuilder builder, int mountingResetTaps) {
        builder.addByte(8, (byte)mountingResetTaps, 0);
    }

    public static void addSetupMode(FlatBufferBuilder builder, boolean setupMode) {
        builder.addBoolean(9, setupMode, false);
    }

    public static void addNumberTrackersOverThreshold(FlatBufferBuilder builder, int numberTrackersOverThreshold) {
        builder.addByte(10, (byte)numberTrackersOverThreshold, 0);
    }

    public static int endTapDetectionSettings(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public TapDetectionSettingsT unpack() {
        TapDetectionSettingsT _o = new TapDetectionSettingsT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(TapDetectionSettingsT _o) {
        Float _oFullResetDelay = this.hasFullResetDelay() ? Float.valueOf(this.fullResetDelay()) : null;
        _o.setFullResetDelay(_oFullResetDelay);
        Boolean _oFullResetEnabled = this.hasFullResetEnabled() ? Boolean.valueOf(this.fullResetEnabled()) : null;
        _o.setFullResetEnabled(_oFullResetEnabled);
        Integer _oFullResetTaps = this.hasFullResetTaps() ? Integer.valueOf(this.fullResetTaps()) : null;
        _o.setFullResetTaps(_oFullResetTaps);
        Float _oYawResetDelay = this.hasYawResetDelay() ? Float.valueOf(this.yawResetDelay()) : null;
        _o.setYawResetDelay(_oYawResetDelay);
        Boolean _oYawResetEnabled = this.hasYawResetEnabled() ? Boolean.valueOf(this.yawResetEnabled()) : null;
        _o.setYawResetEnabled(_oYawResetEnabled);
        Integer _oYawResetTaps = this.hasYawResetTaps() ? Integer.valueOf(this.yawResetTaps()) : null;
        _o.setYawResetTaps(_oYawResetTaps);
        Float _oMountingResetDelay = this.hasMountingResetDelay() ? Float.valueOf(this.mountingResetDelay()) : null;
        _o.setMountingResetDelay(_oMountingResetDelay);
        Boolean _oMountingResetEnabled = this.hasMountingResetEnabled() ? Boolean.valueOf(this.mountingResetEnabled()) : null;
        _o.setMountingResetEnabled(_oMountingResetEnabled);
        Integer _oMountingResetTaps = this.hasMountingResetTaps() ? Integer.valueOf(this.mountingResetTaps()) : null;
        _o.setMountingResetTaps(_oMountingResetTaps);
        Boolean _oSetupMode = this.hasSetupMode() ? Boolean.valueOf(this.setupMode()) : null;
        _o.setSetupMode(_oSetupMode);
        Integer _oNumberTrackersOverThreshold = this.hasNumberTrackersOverThreshold() ? Integer.valueOf(this.numberTrackersOverThreshold()) : null;
        _o.setNumberTrackersOverThreshold(_oNumberTrackersOverThreshold);
    }

    public static int pack(FlatBufferBuilder builder, TapDetectionSettingsT _o) {
        if (_o == null) {
            return 0;
        }
        return TapDetectionSettings.createTapDetectionSettings(builder, _o.getFullResetDelay().floatValue(), _o.getFullResetEnabled(), _o.getFullResetTaps(), _o.getYawResetDelay().floatValue(), _o.getYawResetEnabled(), _o.getYawResetTaps(), _o.getMountingResetDelay().floatValue(), _o.getMountingResetEnabled(), _o.getMountingResetTaps(), _o.getSetupMode(), _o.getNumberTrackersOverThreshold());
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public TapDetectionSettings get(int j) {
            return this.get(new TapDetectionSettings(), j);
        }

        public TapDetectionSettings get(TapDetectionSettings obj, int j) {
            return obj.__assign(TapDetectionSettings.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

