/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.rpc;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.ByteVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.rpc.VRCConfigRecommendedValuesT;

public final class VRCConfigRecommendedValues
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static VRCConfigRecommendedValues getRootAsVRCConfigRecommendedValues(ByteBuffer _bb) {
        return VRCConfigRecommendedValues.getRootAsVRCConfigRecommendedValues(_bb, new VRCConfigRecommendedValues());
    }

    public static VRCConfigRecommendedValues getRootAsVRCConfigRecommendedValues(ByteBuffer _bb, VRCConfigRecommendedValues obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public VRCConfigRecommendedValues __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public boolean legacyMode() {
        int o = this.__offset(4);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean shoulderTrackingDisabled() {
        int o = this.__offset(6);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public float userHeight() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public float calibrationRange() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public boolean calibrationVisuals() {
        int o = this.__offset(12);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public int trackerModel() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public int spineMode(int j) {
        int o = this.__offset(16);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) & 0xFF : 0;
    }

    public int spineModeLength() {
        int o = this.__offset(16);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteVector spineModeVector() {
        return this.spineModeVector(new ByteVector());
    }

    public ByteVector spineModeVector(ByteVector obj) {
        int o = this.__offset(16);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer spineModeAsByteBuffer() {
        return this.__vector_as_bytebuffer(16, 1);
    }

    public ByteBuffer spineModeInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 16, 1);
    }

    public int avatarMeasurementType() {
        int o = this.__offset(18);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public boolean shoulderWidthCompensation() {
        int o = this.__offset(20);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public static int createVRCConfigRecommendedValues(FlatBufferBuilder builder, boolean legacyMode, boolean shoulderTrackingDisabled, float userHeight, float calibrationRange, boolean calibrationVisuals, int trackerModel, int spineModeOffset, int avatarMeasurementType, boolean shoulderWidthCompensation) {
        builder.startTable(9);
        VRCConfigRecommendedValues.addSpineMode(builder, spineModeOffset);
        VRCConfigRecommendedValues.addCalibrationRange(builder, calibrationRange);
        VRCConfigRecommendedValues.addUserHeight(builder, userHeight);
        VRCConfigRecommendedValues.addShoulderWidthCompensation(builder, shoulderWidthCompensation);
        VRCConfigRecommendedValues.addAvatarMeasurementType(builder, avatarMeasurementType);
        VRCConfigRecommendedValues.addTrackerModel(builder, trackerModel);
        VRCConfigRecommendedValues.addCalibrationVisuals(builder, calibrationVisuals);
        VRCConfigRecommendedValues.addShoulderTrackingDisabled(builder, shoulderTrackingDisabled);
        VRCConfigRecommendedValues.addLegacyMode(builder, legacyMode);
        return VRCConfigRecommendedValues.endVRCConfigRecommendedValues(builder);
    }

    public static void startVRCConfigRecommendedValues(FlatBufferBuilder builder) {
        builder.startTable(9);
    }

    public static void addLegacyMode(FlatBufferBuilder builder, boolean legacyMode) {
        builder.addBoolean(0, legacyMode, false);
    }

    public static void addShoulderTrackingDisabled(FlatBufferBuilder builder, boolean shoulderTrackingDisabled) {
        builder.addBoolean(1, shoulderTrackingDisabled, false);
    }

    public static void addUserHeight(FlatBufferBuilder builder, float userHeight) {
        builder.addFloat(2, userHeight, 0.0);
    }

    public static void addCalibrationRange(FlatBufferBuilder builder, float calibrationRange) {
        builder.addFloat(3, calibrationRange, 0.0);
    }

    public static void addCalibrationVisuals(FlatBufferBuilder builder, boolean calibrationVisuals) {
        builder.addBoolean(4, calibrationVisuals, false);
    }

    public static void addTrackerModel(FlatBufferBuilder builder, int trackerModel) {
        builder.addByte(5, (byte)trackerModel, 0);
    }

    public static void addSpineMode(FlatBufferBuilder builder, int spineModeOffset) {
        builder.addOffset(6, spineModeOffset, 0);
    }

    public static int createSpineModeVector(FlatBufferBuilder builder, byte[] data) {
        return builder.createByteVector(data);
    }

    public static int createSpineModeVector(FlatBufferBuilder builder, ByteBuffer data) {
        return builder.createByteVector(data);
    }

    public static void startSpineModeVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static void addAvatarMeasurementType(FlatBufferBuilder builder, int avatarMeasurementType) {
        builder.addByte(7, (byte)avatarMeasurementType, 0);
    }

    public static void addShoulderWidthCompensation(FlatBufferBuilder builder, boolean shoulderWidthCompensation) {
        builder.addBoolean(8, shoulderWidthCompensation, false);
    }

    public static int endVRCConfigRecommendedValues(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public VRCConfigRecommendedValuesT unpack() {
        VRCConfigRecommendedValuesT _o = new VRCConfigRecommendedValuesT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(VRCConfigRecommendedValuesT _o) {
        boolean _oLegacyMode = this.legacyMode();
        _o.setLegacyMode(_oLegacyMode);
        boolean _oShoulderTrackingDisabled = this.shoulderTrackingDisabled();
        _o.setShoulderTrackingDisabled(_oShoulderTrackingDisabled);
        float _oUserHeight = this.userHeight();
        _o.setUserHeight(_oUserHeight);
        float _oCalibrationRange = this.calibrationRange();
        _o.setCalibrationRange(_oCalibrationRange);
        boolean _oCalibrationVisuals = this.calibrationVisuals();
        _o.setCalibrationVisuals(_oCalibrationVisuals);
        int _oTrackerModel = this.trackerModel();
        _o.setTrackerModel(_oTrackerModel);
        int[] _oSpineMode = new int[this.spineModeLength()];
        for (int _j = 0; _j < this.spineModeLength(); ++_j) {
            _oSpineMode[_j] = this.spineMode(_j);
        }
        _o.setSpineMode(_oSpineMode);
        int _oAvatarMeasurementType = this.avatarMeasurementType();
        _o.setAvatarMeasurementType(_oAvatarMeasurementType);
        boolean _oShoulderWidthCompensation = this.shoulderWidthCompensation();
        _o.setShoulderWidthCompensation(_oShoulderWidthCompensation);
    }

    public static int pack(FlatBufferBuilder builder, VRCConfigRecommendedValuesT _o) {
        if (_o == null) {
            return 0;
        }
        int _spineMode = 0;
        if (_o.getSpineMode() != null) {
            byte[] __spineMode = new byte[_o.getSpineMode().length];
            int _j = 0;
            for (int _e : _o.getSpineMode()) {
                __spineMode[_j] = (byte)_e;
                ++_j;
            }
            _spineMode = VRCConfigRecommendedValues.createSpineModeVector(builder, __spineMode);
        }
        return VRCConfigRecommendedValues.createVRCConfigRecommendedValues(builder, _o.getLegacyMode(), _o.getShoulderTrackingDisabled(), _o.getUserHeight(), _o.getCalibrationRange(), _o.getCalibrationVisuals(), _o.getTrackerModel(), _spineMode, _o.getAvatarMeasurementType(), _o.getShoulderWidthCompensation());
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public VRCConfigRecommendedValues get(int j) {
            return this.get(new VRCConfigRecommendedValues(), j);
        }

        public VRCConfigRecommendedValues get(VRCConfigRecommendedValues obj, int j) {
            return obj.__assign(VRCConfigRecommendedValues.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

