/*
 * Decompiled with CFR 0.152.
 */
package solarxr_protocol.rpc;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import solarxr_protocol.rpc.VRCConfigValuesT;

public final class VRCConfigValues
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_22_10_26();
    }

    public static VRCConfigValues getRootAsVRCConfigValues(ByteBuffer _bb) {
        return VRCConfigValues.getRootAsVRCConfigValues(_bb, new VRCConfigValues());
    }

    public static VRCConfigValues getRootAsVRCConfigValues(ByteBuffer _bb, VRCConfigValues obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public VRCConfigValues __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public boolean legacyMode() {
        int o = this.__offset(4);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean shoulderTrackingDisabled() {
        int o = this.__offset(6);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public float userHeight() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public float calibrationRange() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public boolean calibrationVisuals() {
        int o = this.__offset(12);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public int trackerModel() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public int spineMode() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public int avatarMeasurementType() {
        int o = this.__offset(18);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public boolean shoulderWidthCompensation() {
        int o = this.__offset(20);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public static int createVRCConfigValues(FlatBufferBuilder builder, boolean legacyMode, boolean shoulderTrackingDisabled, float userHeight, float calibrationRange, boolean calibrationVisuals, int trackerModel, int spineMode, int avatarMeasurementType, boolean shoulderWidthCompensation) {
        builder.startTable(9);
        VRCConfigValues.addCalibrationRange(builder, calibrationRange);
        VRCConfigValues.addUserHeight(builder, userHeight);
        VRCConfigValues.addShoulderWidthCompensation(builder, shoulderWidthCompensation);
        VRCConfigValues.addAvatarMeasurementType(builder, avatarMeasurementType);
        VRCConfigValues.addSpineMode(builder, spineMode);
        VRCConfigValues.addTrackerModel(builder, trackerModel);
        VRCConfigValues.addCalibrationVisuals(builder, calibrationVisuals);
        VRCConfigValues.addShoulderTrackingDisabled(builder, shoulderTrackingDisabled);
        VRCConfigValues.addLegacyMode(builder, legacyMode);
        return VRCConfigValues.endVRCConfigValues(builder);
    }

    public static void startVRCConfigValues(FlatBufferBuilder builder) {
        builder.startTable(9);
    }

    public static void addLegacyMode(FlatBufferBuilder builder, boolean legacyMode) {
        builder.addBoolean(0, legacyMode, false);
    }

    public static void addShoulderTrackingDisabled(FlatBufferBuilder builder, boolean shoulderTrackingDisabled) {
        builder.addBoolean(1, shoulderTrackingDisabled, false);
    }

    public static void addUserHeight(FlatBufferBuilder builder, float userHeight) {
        builder.addFloat(2, userHeight, 0.0);
    }

    public static void addCalibrationRange(FlatBufferBuilder builder, float calibrationRange) {
        builder.addFloat(3, calibrationRange, 0.0);
    }

    public static void addCalibrationVisuals(FlatBufferBuilder builder, boolean calibrationVisuals) {
        builder.addBoolean(4, calibrationVisuals, false);
    }

    public static void addTrackerModel(FlatBufferBuilder builder, int trackerModel) {
        builder.addByte(5, (byte)trackerModel, 0);
    }

    public static void addSpineMode(FlatBufferBuilder builder, int spineMode) {
        builder.addByte(6, (byte)spineMode, 0);
    }

    public static void addAvatarMeasurementType(FlatBufferBuilder builder, int avatarMeasurementType) {
        builder.addByte(7, (byte)avatarMeasurementType, 0);
    }

    public static void addShoulderWidthCompensation(FlatBufferBuilder builder, boolean shoulderWidthCompensation) {
        builder.addBoolean(8, shoulderWidthCompensation, false);
    }

    public static int endVRCConfigValues(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public VRCConfigValuesT unpack() {
        VRCConfigValuesT _o = new VRCConfigValuesT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(VRCConfigValuesT _o) {
        boolean _oLegacyMode = this.legacyMode();
        _o.setLegacyMode(_oLegacyMode);
        boolean _oShoulderTrackingDisabled = this.shoulderTrackingDisabled();
        _o.setShoulderTrackingDisabled(_oShoulderTrackingDisabled);
        float _oUserHeight = this.userHeight();
        _o.setUserHeight(_oUserHeight);
        float _oCalibrationRange = this.calibrationRange();
        _o.setCalibrationRange(_oCalibrationRange);
        boolean _oCalibrationVisuals = this.calibrationVisuals();
        _o.setCalibrationVisuals(_oCalibrationVisuals);
        int _oTrackerModel = this.trackerModel();
        _o.setTrackerModel(_oTrackerModel);
        int _oSpineMode = this.spineMode();
        _o.setSpineMode(_oSpineMode);
        int _oAvatarMeasurementType = this.avatarMeasurementType();
        _o.setAvatarMeasurementType(_oAvatarMeasurementType);
        boolean _oShoulderWidthCompensation = this.shoulderWidthCompensation();
        _o.setShoulderWidthCompensation(_oShoulderWidthCompensation);
    }

    public static int pack(FlatBufferBuilder builder, VRCConfigValuesT _o) {
        if (_o == null) {
            return 0;
        }
        return VRCConfigValues.createVRCConfigValues(builder, _o.getLegacyMode(), _o.getShoulderTrackingDisabled(), _o.getUserHeight(), _o.getCalibrationRange(), _o.getCalibrationVisuals(), _o.getTrackerModel(), _o.getSpineMode(), _o.getAvatarMeasurementType(), _o.getShoulderWidthCompensation());
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public VRCConfigValues get(int j) {
            return this.get(new VRCConfigValues(), j);
        }

        public VRCConfigValues get(VRCConfigValues obj, int j) {
            return obj.__assign(VRCConfigValues.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

